/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.ResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.ResumeStrategyFactory;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignmentListener
implements ConsumerRebalanceListener {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAssignmentListener.class);
    private final String threadId;
    private final String topicName;
    private final KafkaConfiguration configuration;
    private final KafkaConsumer consumer;
    private final Map<String, Long> lastProcessedOffset;
    private final ResumeStrategy resumeStrategy;
    private Supplier<Boolean> stopStateSupplier;

    public PartitionAssignmentListener(String threadId, String topicName, KafkaConfiguration configuration, KafkaConsumer consumer, Map<String, Long> lastProcessedOffset, Supplier<Boolean> stopStateSupplier) {
        this.threadId = threadId;
        this.topicName = topicName;
        this.configuration = configuration;
        this.consumer = consumer;
        this.lastProcessedOffset = lastProcessedOffset;
        this.stopStateSupplier = stopStateSupplier;
        this.resumeStrategy = ResumeStrategyFactory.newResumeStrategy(configuration);
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        LOG.debug("onPartitionsRevoked: {} from topic {}", (Object)this.threadId, (Object)this.topicName);
        boolean stopping = this.stopStateSupplier.get();
        for (TopicPartition partition : partitions) {
            String offsetKey = KafkaRecordProcessor.serializeOffsetKey(partition);
            Long offset = this.lastProcessedOffset.get(offsetKey);
            if (offset == null) {
                offset = -1L;
            }
            try {
                if (!this.configuration.getAutoCommitEnable().booleanValue()) continue;
                KafkaRecordProcessor.commitOffset(this.configuration, this.consumer, partition, offset, stopping, false, this.threadId);
            }
            catch (Exception e) {
                LOG.error("Error saving offset repository state {} from offsetKey {} with offset: {}", new Object[]{this.threadId, offsetKey, offset});
                throw e;
            }
            finally {
                this.lastProcessedOffset.remove(offsetKey);
            }
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        LOG.debug("onPartitionsAssigned: {} from topic {}", (Object)this.threadId, (Object)this.topicName);
        this.resumeStrategy.resume(this.consumer);
    }
}

