/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.support.OffsetResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.ResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.SeekPolicyResumeStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResumeStrategyFactory {
    private static final NoOpResumeStrategy NO_OP_RESUME_STRATEGY = new NoOpResumeStrategy();
    private static final Logger LOG = LoggerFactory.getLogger(ResumeStrategyFactory.class);

    private ResumeStrategyFactory() {
    }

    public static ResumeStrategy newResumeStrategy(KafkaConfiguration configuration) {
        if (configuration.getResumeStrategy() != null) {
            return configuration.getResumeStrategy();
        }
        return ResumeStrategyFactory.builtinResumeStrategies(configuration);
    }

    private static ResumeStrategy builtinResumeStrategies(KafkaConfiguration configuration) {
        StateRepository<String, String> offsetRepository = configuration.getOffsetRepository();
        String seekTo = configuration.getSeekTo();
        if (offsetRepository != null) {
            LOG.info("Using resume from offset strategy");
            return new OffsetResumeStrategy(offsetRepository);
        }
        if (seekTo != null) {
            LOG.info("Using resume from seek policy strategy with seeking from {}", (Object)seekTo);
            return new SeekPolicyResumeStrategy(seekTo);
        }
        LOG.info("Using NO-OP resume strategy");
        return NO_OP_RESUME_STRATEGY;
    }

    private static class NoOpResumeStrategy
    implements ResumeStrategy {
        private NoOpResumeStrategy() {
        }

        @Override
        public void resume(KafkaConsumer<?, ?> consumer) {
        }
    }
}

