/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import org.apache.camel.component.kafka.consumer.support.ResumeStrategy;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekPolicyResumeStrategy
implements ResumeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SeekPolicyResumeStrategy.class);
    private final String seekPolicy;

    public SeekPolicyResumeStrategy(String seekPolicy) {
        this.seekPolicy = seekPolicy;
    }

    @Override
    public void resume(KafkaConsumer<?, ?> consumer) {
        if (this.seekPolicy.equals("beginning")) {
            LOG.debug("Seeking from the beginning of topic");
            consumer.seekToBeginning((Collection)consumer.assignment());
        } else if (this.seekPolicy.equals("end")) {
            LOG.debug("Seeking from the end off the topic");
            consumer.seekToEnd((Collection)consumer.assignment());
        }
    }
}

