/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.camel.component.kafka.consumer.OffsetCache;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCommitManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(SyncCommitManager.class);
    private final OffsetCache offsetCache = new OffsetCache();
    private final Consumer<?, ?> consumer;

    public SyncCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
        this.consumer = consumer;
    }

    @Override
    public void commit() {
        LOG.info("Auto commitSync {} from {}", (Object)this.threadId, (Object)this.printableTopic);
        this.consumer.commitSync();
    }

    @Override
    public void commit(TopicPartition partition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commitSync from thread {} from topic {}", (Object)this.threadId, (Object)partition.topic());
        }
        this.commitSync(partition);
    }

    private void commitSync(TopicPartition partition) {
        Long offset = this.offsetCache.getOffset(partition);
        if (offset == null) {
            return;
        }
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(partition, new OffsetAndMetadata(offset + 1L));
        long timeout = this.configuration.getCommitTimeoutMs();
        this.consumer.commitSync(offsets, Duration.ofMillis(timeout));
        this.offsetCache.removeCommittedEntries(offsets, null);
    }

    @Override
    public void recordOffset(TopicPartition partition, long partitionLastOffset) {
        this.offsetCache.recordOffset(partition, partitionLastOffset);
    }
}

