/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.producer.support.ProducerUtil;
import org.apache.camel.component.kafka.producer.support.PropagatedHeadersProvider;
import org.apache.camel.util.KeyValueHolder;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KeyValueHolderIterator
implements Iterator<KeyValueHolder<Object, ProducerRecord<Object, Object>>> {
    private final Iterator<Object> msgList;
    private final Exchange exchange;
    private final KafkaConfiguration kafkaConfiguration;
    private final String msgTopic;
    private final PropagatedHeadersProvider propagatedHeadersProvider;

    public KeyValueHolderIterator(Iterator<Object> msgList, Exchange exchange, KafkaConfiguration kafkaConfiguration, String msgTopic, PropagatedHeadersProvider propagatedHeadersProvider) {
        this.msgList = msgList;
        this.exchange = exchange;
        this.kafkaConfiguration = kafkaConfiguration;
        this.msgTopic = msgTopic;
        this.propagatedHeadersProvider = propagatedHeadersProvider;
    }

    @Override
    public boolean hasNext() {
        return this.msgList.hasNext();
    }

    @Override
    public KeyValueHolder<Object, ProducerRecord<Object, Object>> next() {
        Object body = this.msgList.next();
        if (body instanceof Exchange || body instanceof Message) {
            Message innerMessage = this.getInnerMessage(body);
            Exchange innerExchange = this.getInnerExchange(body);
            String innerTopic = this.getInnerTopic(innerMessage);
            Integer innerPartitionKey = this.getInnerPartitionKey(innerMessage);
            Object innerKey = this.getInnerKey(innerExchange, innerMessage);
            Long innerTimestamp = this.getOverrideTimestamp(innerMessage);
            Exchange ex = innerExchange == null ? this.exchange : innerExchange;
            Object value = ProducerUtil.tryConvertToSerializedType(ex, innerMessage.getBody(), this.kafkaConfiguration.getValueSerializer());
            return new KeyValueHolder(body, (Object)new ProducerRecord(innerTopic, innerPartitionKey, innerTimestamp, innerKey, value, this.propagatedHeadersProvider.getHeaders(ex, innerMessage)));
        }
        return new KeyValueHolder(body, (Object)new ProducerRecord(this.msgTopic, null, null, null, body, this.propagatedHeadersProvider.getDefaultHeaders()));
    }

    private Message getInnerMessage(Object body) {
        if (body instanceof Exchange) {
            return ((Exchange)body).getIn();
        }
        return (Message)body;
    }

    private Exchange getInnerExchange(Object body) {
        if (body instanceof Exchange) {
            return (Exchange)body;
        }
        return null;
    }

    private Long getOverrideTimestamp(Message innerMessage) {
        Long timeStamp = null;
        Object overrideTimeStamp = innerMessage.removeHeader("kafka.OVERRIDE_TIMESTAMP");
        if (overrideTimeStamp != null) {
            timeStamp = (Long)this.exchange.getContext().getTypeConverter().convertTo(Long.class, this.exchange, overrideTimeStamp);
        }
        return timeStamp;
    }

    private String getInnerTopic(Message innerMessage) {
        if (innerMessage.getHeader("kafka.OVERRIDE_TOPIC") != null) {
            return (String)innerMessage.removeHeader("kafka.OVERRIDE_TOPIC");
        }
        return this.msgTopic;
    }

    private Object getInnerKey(Exchange innerExchange, Message innerMessage) {
        Object innerKey = innerMessage.getHeader("kafka.KEY");
        if (innerKey != null) {
            Object object = innerKey = this.kafkaConfiguration.getKey() != null ? this.kafkaConfiguration.getKey() : innerKey;
            if (innerKey != null) {
                innerKey = ProducerUtil.tryConvertToSerializedType(innerExchange, innerKey, this.kafkaConfiguration.getKeySerializer());
            }
            return innerKey;
        }
        return null;
    }

    private Integer getInnerPartitionKey(Message innerMessage) {
        Integer partitionKey = (Integer)innerMessage.getHeader("kafka.PARTITION_KEY", Integer.class);
        return this.kafkaConfiguration.getPartitionKey() != null ? this.kafkaConfiguration.getPartitionKey() : partitionKey;
    }

    @Override
    public void remove() {
        this.msgList.remove();
    }
}

