/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.deploymentconfigs;

import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.openshift.deploymentconfigs.DeploymentConfigEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftDeploymentConfigsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftDeploymentConfigsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private DeploymentsConfigConsumerTask deploymentsWatcher;

    public OpenshiftDeploymentConfigsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.deploymentsWatcher = new DeploymentsConfigConsumerTask();
        this.executor.submit(this.deploymentsWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Openshift DeploymentConfigs Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.deploymentsWatcher, this.deploymentsWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class DeploymentsConfigConsumerTask
    implements Runnable {
        private Watch watch;

        DeploymentsConfigConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = ((OpenShiftClient)OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).deploymentConfigs();
            if (ObjectHelper.isNotEmpty((String)OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((String)OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)OpenshiftDeploymentConfigsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((MixedOperation)w).withName(arg_0));
            this.watch = w.watch((Watcher)new Watcher<DeploymentConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, DeploymentConfig resource) {
                    DeploymentConfigEvent de = new DeploymentConfigEvent(action, resource);
                    Exchange exchange = OpenshiftDeploymentConfigsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)de.getDeploymentConfig());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)de.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        OpenshiftDeploymentConfigsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        OpenshiftDeploymentConfigsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        OpenshiftDeploymentConfigsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

