/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.lumberjack.io.LumberjackMessage;

public class LumberjackWindow
implements Iterable<LumberjackMessage> {
    private final byte version;
    private final int size;
    private List<LumberjackMessage> messages = new ArrayList<LumberjackMessage>();

    public LumberjackWindow(byte version, int size) {
        this.version = version;
        this.size = size;
    }

    @Override
    public Iterator<LumberjackMessage> iterator() {
        return this.messages.iterator();
    }

    void addMessage(LumberjackMessage message) {
        this.messages.add(message);
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean isComplete() {
        return this.size == this.messages.size();
    }

    public int getSize() {
        return this.size;
    }
}

