/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.io.IOException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mybatis.DefaultMyBatisProcessingStrategy;
import org.apache.camel.component.mybatis.MyBatisComponent;
import org.apache.camel.component.mybatis.MyBatisConsumer;
import org.apache.camel.component.mybatis.MyBatisProcessingStrategy;
import org.apache.camel.component.mybatis.MyBatisProducer;
import org.apache.camel.component.mybatis.StatementType;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;

@UriEndpoint(scheme="mybatis", consumerClass=MyBatisConsumer.class)
public class MyBatisEndpoint
extends DefaultPollingEndpoint {
    private MyBatisProcessingStrategy processingStrategy = new DefaultMyBatisProcessingStrategy();
    private ExecutorType executorType;
    @UriParam
    private String statement;
    @UriParam
    private StatementType statementType;
    @UriParam
    private int maxMessagesPerPoll;

    public MyBatisEndpoint() {
    }

    public MyBatisEndpoint(String endpointUri, Component component, String statement) {
        super(endpointUri, component);
        this.statement = statement;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.statementType), (String)"statementType", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.statement, (String)"statement", (Object)((Object)this));
        return new MyBatisProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.statement, (String)"statement", (Object)((Object)this));
        MyBatisConsumer consumer = new MyBatisConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public MyBatisComponent getComponent() {
        return (MyBatisComponent)super.getComponent();
    }

    public SqlSessionFactory getSqlSessionFactory() throws IOException {
        return this.getComponent().getSqlSessionFactory();
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public void setExecutorType(String executorType) {
        this.executorType = ExecutorType.valueOf((String)executorType.toUpperCase());
    }

    public MyBatisProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(MyBatisProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

