/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import java.net.SocketAddress;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.handlers.ServerResponseFutureListener;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.IOHelper;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private final NettyConsumer consumer;
    private final CamelLogger noReplyLogger;

    public ServerChannelHandler(NettyConsumer consumer) {
        this.consumer = consumer;
        this.noReplyLogger = new CamelLogger(LOG, consumer.getConfiguration().getNoReplyLogLevel());
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel open: {}", (Object)e.getChannel());
        }
        this.consumer.getNettyServerBootstrapFactory().addChannel(e.getChannel());
        super.channelOpen(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel closed: {}", (Object)e.getChannel());
        }
        this.consumer.getNettyServerBootstrapFactory().removeChannel(e.getChannel());
        super.channelClosed(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (this.consumer.isRunAllowed()) {
            this.consumer.getExceptionHandler().handleException("Closing channel as an exception was thrown from Netty", exceptionEvent.getCause());
            NettyHelper.close(exceptionEvent.getChannel());
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Object in = messageEvent.getMessage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", new Object[]{messageEvent.getChannel(), in});
        }
        Exchange exchange = this.consumer.getEndpoint().createExchange(ctx, messageEvent);
        if (this.consumer.getConfiguration().isSync()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        if (this.consumer.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)this.consumer.getConfiguration().getCharsetName()));
        }
        this.consumer.createUoW(exchange);
        this.beforeProcess(exchange, messageEvent);
        if (this.consumer.getEndpoint().isSynchronous()) {
            this.processSynchronously(exchange, messageEvent);
        } else {
            this.processAsynchronously(exchange, messageEvent);
        }
    }

    protected void beforeProcess(Exchange exchange, MessageEvent messageEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSynchronously(Exchange exchange, MessageEvent messageEvent) {
        try {
            this.consumer.getProcessor().process(exchange);
            if (this.consumer.getConfiguration().isSync()) {
                this.sendResponse(messageEvent, exchange);
            }
        }
        catch (Throwable e) {
            this.consumer.getExceptionHandler().handleException(e);
        }
        finally {
            this.consumer.doneUoW(exchange);
        }
    }

    private void processAsynchronously(final Exchange exchange, final MessageEvent messageEvent) {
        this.consumer.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                try {
                    if (ServerChannelHandler.this.consumer.getConfiguration().isSync()) {
                        ServerChannelHandler.this.sendResponse(messageEvent, exchange);
                    }
                }
                catch (Throwable e) {
                    ServerChannelHandler.this.consumer.getExceptionHandler().handleException(e);
                }
                finally {
                    ServerChannelHandler.this.consumer.doneUoW(exchange);
                }
            }
        });
    }

    private void sendResponse(MessageEvent messageEvent, Exchange exchange) throws Exception {
        Object body = this.getResponseBody(exchange);
        if (body == null) {
            this.noReplyLogger.log("No payload to send as reply for exchange: " + exchange);
            if (this.consumer.getConfiguration().isDisconnectOnNoReply()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel as no payload to send as reply at address: {}", (Object)messageEvent.getRemoteAddress());
                }
                NettyHelper.close(messageEvent.getChannel());
            }
        } else {
            if (this.consumer.getConfiguration().isTextline()) {
                body = NettyHelper.getTextlineBody(body, exchange, this.consumer.getConfiguration().getDelimiter(), this.consumer.getConfiguration().isAutoAppendDelimiter());
            }
            ChannelFutureListener listener = this.createResponseFutureListener(this.consumer, exchange, messageEvent.getRemoteAddress());
            if (this.consumer.getConfiguration().isTcp()) {
                NettyHelper.writeBodyAsync(LOG, messageEvent.getChannel(), null, body, exchange, listener);
            } else {
                NettyHelper.writeBodyAsync(LOG, messageEvent.getChannel(), messageEvent.getRemoteAddress(), body, exchange, listener);
            }
        }
    }

    protected Object getResponseBody(Exchange exchange) throws Exception {
        boolean exception;
        boolean bl = exception = exchange.getException() != null && !this.consumer.getEndpoint().getConfiguration().isTransferExchange();
        if (exception) {
            return exchange.getException();
        }
        if (exchange.hasOut()) {
            return NettyPayloadHelper.getOut(this.consumer.getEndpoint(), exchange);
        }
        return NettyPayloadHelper.getIn(this.consumer.getEndpoint(), exchange);
    }

    protected ChannelFutureListener createResponseFutureListener(NettyConsumer consumer, Exchange exchange, SocketAddress remoteAddress) {
        return new ServerResponseFutureListener(consumer, exchange, remoteAddress);
    }
}

