/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NettyEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol://host:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "netty".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(76);
        props.add("usingExecutorService");
        props.add("disconnect");
        props.add("enabledProtocols");
        props.add("synchronous");
        props.add("hostnameVerification");
        props.add("keyStoreFormat");
        props.add("producerPoolMinIdle");
        props.add("ssl");
        props.add("bossGroup");
        props.add("protocol");
        props.add("bridgeErrorHandler");
        props.add("securityProvider");
        props.add("delimiter");
        props.add("host");
        props.add("connectTimeout");
        props.add("options");
        props.add("textline");
        props.add("producerPoolBlockWhenExhausted");
        props.add("workerGroup");
        props.add("producerPoolMinEvictableIdle");
        props.add("tcpNoDelay");
        props.add("udpConnectionlessSending");
        props.add("needClientAuth");
        props.add("sslHandler");
        props.add("encoders");
        props.add("keyStoreFile");
        props.add("decoders");
        props.add("reuseAddress");
        props.add("encoding");
        props.add("sync");
        props.add("workerCount");
        props.add("lazyStartProducer");
        props.add("backlog");
        props.add("port");
        props.add("producerPoolMaxTotal");
        props.add("networkInterface");
        props.add("allowDefaultCodec");
        props.add("passphrase");
        props.add("clientMode");
        props.add("nettyServerBootstrapFactory");
        props.add("decoderMaxLineLength");
        props.add("exceptionHandler");
        props.add("broadcast");
        props.add("trustStoreResource");
        props.add("bossCount");
        props.add("serverInitializerFactory");
        props.add("sslClientCertHeaders");
        props.add("disconnectOnNoReply");
        props.add("useByteBuf");
        props.add("sslContextParameters");
        props.add("correlationManager");
        props.add("producerPoolMaxWait");
        props.add("keyStoreResource");
        props.add("autoAppendDelimiter");
        props.add("reuseChannel");
        props.add("producerPoolMaxIdle");
        props.add("reconnect");
        props.add("producerPoolEnabled");
        props.add("trustStoreFile");
        props.add("noReplyLogLevel");
        props.add("transferExchange");
        props.add("requestTimeout");
        props.add("receiveBufferSizePredictor");
        props.add("keepAlive");
        props.add("clientInitializerFactory");
        props.add("sendBufferSize");
        props.add("exchangePattern");
        props.add("reconnectInterval");
        props.add("lazyChannelCreation");
        props.add("allowSerializedHeaders");
        props.add("channelGroup");
        props.add("receiveBufferSize");
        props.add("serverClosedChannelExceptionCaughtLogLevel");
        props.add("nativeTransport");
        props.add("udpByteArrayCodec");
        props.add("serverExceptionCaughtLogLevel");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("passphrase");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

