/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ChannelHandlerFactories;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
@Configurer
public class NettyConfiguration
extends NettyServerBootstrapConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfiguration.class);
    private transient List<ChannelHandler> encodersList = new ArrayList<ChannelHandler>();
    private transient List<ChannelHandler> decodersList = new ArrayList<ChannelHandler>();
    @UriParam(label="producer")
    private long requestTimeout;
    @UriParam(defaultValue="true")
    private boolean sync = true;
    @UriParam(label="codec")
    private boolean textline;
    @UriParam(label="codec", defaultValue="LINE")
    private TextLineDelimiter delimiter = TextLineDelimiter.LINE;
    @UriParam(label="codec", defaultValue="true")
    private boolean autoAppendDelimiter = true;
    @UriParam(label="codec", defaultValue="1024")
    private int decoderMaxLineLength = 1024;
    @UriParam(label="codec")
    private String encoding;
    @UriParam(label="codec")
    private String encoders;
    @UriParam(label="codec")
    private String decoders;
    @UriParam(label="common, security", defaultValue="false")
    private boolean hostnameVerification;
    @UriParam
    private boolean disconnect;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean lazyChannelCreation = true;
    @UriParam(label="advanced")
    private boolean transferExchange;
    @UriParam(label="advanced", defaultValue="false")
    private boolean allowSerializedHeaders;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean disconnectOnNoReply = true;
    @UriParam(label="consumer,advanced", defaultValue="WARN")
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    @UriParam(label="consumer,advanced", defaultValue="WARN")
    private LoggingLevel serverExceptionCaughtLogLevel = LoggingLevel.WARN;
    @UriParam(label="consumer,advanced", defaultValue="DEBUG")
    private LoggingLevel serverClosedChannelExceptionCaughtLogLevel = LoggingLevel.DEBUG;
    @UriParam(label="codec", defaultValue="true")
    private boolean allowDefaultCodec = true;
    @UriParam(label="producer,advanced")
    private ClientInitializerFactory clientInitializerFactory;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean usingExecutorService = true;
    @UriParam(label="producer,advanced", defaultValue="-1")
    private int producerPoolMaxTotal = -1;
    @UriParam(label="producer,advanced")
    private int producerPoolMinIdle;
    @UriParam(label="producer,advanced", defaultValue="100")
    private int producerPoolMaxIdle = 100;
    @UriParam(label="producer,advanced", defaultValue="300000")
    private long producerPoolMinEvictableIdle = 300000L;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean producerPoolEnabled = true;
    @UriParam(label="producer,advanced")
    private boolean udpConnectionlessSending;
    @UriParam(label="consumer")
    private boolean clientMode;
    @UriParam(label="producer,advanced")
    private boolean useByteBuf;
    @UriParam(label="advanced")
    private boolean udpByteArrayCodec;
    @UriParam(label="common")
    private boolean reuseChannel;
    @UriParam(label="producer,advanced")
    private NettyCamelStateCorrelationManager correlationManager;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            answer.setEncodersAsList(new ArrayList<ChannelHandler>(this.getEncodersAsList()));
            answer.setDecodersAsList(new ArrayList<ChannelHandler>(this.getDecodersAsList()));
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void validateConfiguration() {
        for (ChannelHandler encoder : this.encodersList) {
            if (encoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)encoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The encoder {} is not @Shareable or an ChannelHandlerFactory instance. The encoder cannot safely be used.", (Object)encoder);
        }
        for (ChannelHandler decoder : this.decodersList) {
            if (decoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)decoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The decoder {} is not @Shareable or an ChannelHandlerFactory instance. The decoder cannot safely be used.", (Object)decoder);
        }
        if (this.sslHandler != null) {
            boolean shareable;
            boolean factory = this.sslHandler instanceof ChannelHandlerFactory;
            boolean bl = shareable = ObjectHelper.getAnnotation((Object)this.sslHandler, ChannelHandler.Sharable.class) != null;
            if (!factory && !shareable) {
                LOG.warn("The sslHandler {} is not @Shareable or an ChannelHandlerFactory instance. The sslHandler cannot safely be used.", (Object)this.sslHandler);
            }
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component, String ... supportedProtocols) throws Exception {
        this.protocol = uri.getScheme();
        boolean found = false;
        for (String supportedProtocol : supportedProtocols) {
            if (this.protocol == null || !this.protocol.equalsIgnoreCase(supportedProtocol)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        if (uri.getPort() != -1) {
            this.setPort(uri.getPort());
        }
        this.ssl = (Boolean)component.getAndRemoveOrResolveReferenceParameter(parameters, "ssl", Boolean.TYPE, false);
        this.sslHandler = (SslHandler)component.getAndRemoveOrResolveReferenceParameter(parameters, "sslHandler", SslHandler.class, this.sslHandler);
        this.passphrase = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "passphrase", String.class, this.passphrase);
        this.keyStoreFormat = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "keyStoreFormat", String.class, this.keyStoreFormat == null ? "JKS" : this.keyStoreFormat);
        this.securityProvider = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "securityProvider", String.class, this.securityProvider == null ? "SunX509" : this.securityProvider);
        this.keyStoreResource = this.uriRef(component, parameters, "keyStoreResource", this.keyStoreResource);
        this.trustStoreResource = this.uriRef(component, parameters, "trustStoreResource", this.trustStoreResource);
        this.clientInitializerFactory = (ClientInitializerFactory)((Object)component.getAndRemoveOrResolveReferenceParameter(parameters, "clientInitializerFactory", ClientInitializerFactory.class, (Object)this.clientInitializerFactory));
        this.serverInitializerFactory = (ServerInitializerFactory)((Object)component.getAndRemoveOrResolveReferenceParameter(parameters, "serverInitializerFactory", ServerInitializerFactory.class, (Object)this.serverInitializerFactory));
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.encodersList, referencedEncoders, ChannelHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.decodersList, referencedDecoders, ChannelHandler.class);
        List configEncoders = EndpointHelper.resolveReferenceListParameter((CamelContext)component.getCamelContext(), (String)this.encoders, ChannelHandler.class);
        NettyConfiguration.addToHandlersList(this.encodersList, configEncoders, ChannelHandler.class);
        List configDecoders = EndpointHelper.resolveReferenceListParameter((CamelContext)component.getCamelContext(), (String)this.decoders, ChannelHandler.class);
        NettyConfiguration.addToHandlersList(this.decodersList, configDecoders, ChannelHandler.class);
        PropertyConfigurer configurer = ((ExtendedCamelContext)component.getCamelContext().adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(this.getClass().getName(), component.getCamelContext());
        PropertyBindingSupport.build().withCamelContext(component.getCamelContext()).withTarget((Object)this).withReflection(false).withIgnoreCase(true).withConfigurer(configurer).withProperties(parameters).bind();
        this.options = PropertiesHelper.extractProperties(parameters, (String)"option.");
        if (this.options.isEmpty()) {
            this.options = null;
        }
        if (this.encodersList.isEmpty() && this.decodersList.isEmpty()) {
            if (this.isAllowDefaultCodec()) {
                if ("udp".equalsIgnoreCase(this.protocol)) {
                    this.encodersList.add(ChannelHandlerFactories.newDatagramPacketEncoder());
                }
                if (this.isTextline()) {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encodersList.add(ChannelHandlerFactories.newStringEncoder(charset, this.protocol));
                    ByteBuf[] delimiters = this.delimiter == TextLineDelimiter.LINE ? Delimiters.lineDelimiter() : Delimiters.nulDelimiter();
                    this.decodersList.add(ChannelHandlerFactories.newDelimiterBasedFrameDecoder(this.decoderMaxLineLength, delimiters, this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newStringDecoder(charset, this.protocol));
                    LOG.debug("Using textline encoders and decoders with charset: {}, delimiter: {} and decoderMaxLineLength: {}", new Object[]{charset, this.delimiter, this.decoderMaxLineLength});
                } else if ("udp".equalsIgnoreCase(this.protocol) && this.isUdpByteArrayCodec()) {
                    this.encodersList.add(ChannelHandlerFactories.newByteArrayEncoder(this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newByteArrayDecoder(this.protocol));
                } else {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encodersList.add(ChannelHandlerFactories.newStringEncoder(charset, this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newStringDecoder(charset, this.protocol));
                }
                if ("udp".equalsIgnoreCase(this.protocol)) {
                    this.decodersList.add(ChannelHandlerFactories.newDatagramPacketDecoder());
                }
            } else {
                LOG.debug("No encoders and decoders will be used");
            }
        } else {
            LOG.debug("Using configured encoders and/or decoders");
        }
    }

    private String uriRef(NettyComponent component, Map<String, Object> parameters, String key, String defaultValue) {
        Object value = parameters.remove(key);
        if (value == null) {
            value = defaultValue;
        } else if (value instanceof String && EndpointHelper.isReferenceParameter((String)((String)value))) {
            String name = ((String)value).replace("#", "");
            value = CamelContextHelper.mandatoryLookup((CamelContext)component.getCamelContext(), (String)name);
        }
        if (value instanceof File) {
            return "file:" + value.toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public TextLineDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(TextLineDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isAutoAppendDelimiter() {
        return this.autoAppendDelimiter;
    }

    public void setAutoAppendDelimiter(boolean autoAppendDelimiter) {
        this.autoAppendDelimiter = autoAppendDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<ChannelHandler> getDecodersAsList() {
        return this.decodersList;
    }

    public void setDecodersAsList(List<ChannelHandler> decoders) {
        this.decodersList = decoders;
    }

    public void setDecoders(List<ChannelHandler> decoders) {
        this.decodersList = decoders;
    }

    public void setDecoders(String decoders) {
        this.decoders = decoders;
    }

    public String getDecoders() {
        return this.decoders;
    }

    public List<ChannelHandler> getEncodersAsList() {
        return this.encodersList;
    }

    public void setEncodersAsList(List<ChannelHandler> encoders) {
        this.encodersList = encoders;
    }

    public void setEncoders(List<ChannelHandler> encoders) {
        this.encodersList = encoders;
    }

    public void setEncoders(String encoders) {
        this.encoders = encoders;
    }

    public String getEncoders() {
        return this.encoders;
    }

    public void addEncoder(ChannelHandler encoder) {
        if (!this.encodersList.contains(encoder)) {
            this.encodersList.add(encoder);
        }
    }

    public void addDecoder(ChannelHandler decoder) {
        if (!this.decodersList.contains(decoder)) {
            this.decodersList.add(decoder);
        }
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public LoggingLevel getServerExceptionCaughtLogLevel() {
        return this.serverExceptionCaughtLogLevel;
    }

    public void setServerExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
        this.serverExceptionCaughtLogLevel = serverExceptionCaughtLogLevel;
    }

    public LoggingLevel getServerClosedChannelExceptionCaughtLogLevel() {
        return this.serverClosedChannelExceptionCaughtLogLevel;
    }

    public void setServerClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
        this.serverClosedChannelExceptionCaughtLogLevel = serverClosedChannelExceptionCaughtLogLevel;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    @Deprecated
    public void setClientPipelineFactory(ClientInitializerFactory clientPipelineFactory) {
        this.clientInitializerFactory = clientPipelineFactory;
    }

    @Deprecated
    public ClientInitializerFactory getClientPipelineFactory() {
        return this.clientInitializerFactory;
    }

    public ClientInitializerFactory getClientInitializerFactory() {
        return this.clientInitializerFactory;
    }

    public void setClientInitializerFactory(ClientInitializerFactory clientInitializerFactory) {
        this.clientInitializerFactory = clientInitializerFactory;
    }

    public boolean isUsingExecutorService() {
        return this.usingExecutorService;
    }

    public void setUsingExecutorService(boolean usingExecutorService) {
        this.usingExecutorService = usingExecutorService;
    }

    public int getProducerPoolMaxTotal() {
        return this.producerPoolMaxTotal;
    }

    public void setProducerPoolMaxTotal(int producerPoolMaxTotal) {
        this.producerPoolMaxTotal = producerPoolMaxTotal;
    }

    public int getProducerPoolMinIdle() {
        return this.producerPoolMinIdle;
    }

    public void setProducerPoolMinIdle(int producerPoolMinIdle) {
        this.producerPoolMinIdle = producerPoolMinIdle;
    }

    public int getProducerPoolMaxIdle() {
        return this.producerPoolMaxIdle;
    }

    public void setProducerPoolMaxIdle(int producerPoolMaxIdle) {
        this.producerPoolMaxIdle = producerPoolMaxIdle;
    }

    public long getProducerPoolMinEvictableIdle() {
        return this.producerPoolMinEvictableIdle;
    }

    public void setProducerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
        this.producerPoolMinEvictableIdle = producerPoolMinEvictableIdle;
    }

    public boolean isProducerPoolEnabled() {
        return this.producerPoolEnabled;
    }

    public void setProducerPoolEnabled(boolean producerPoolEnabled) {
        this.producerPoolEnabled = producerPoolEnabled;
    }

    public boolean isUdpConnectionlessSending() {
        return this.udpConnectionlessSending;
    }

    public void setUdpConnectionlessSending(boolean udpConnectionlessSending) {
        this.udpConnectionlessSending = udpConnectionlessSending;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isUseByteBuf() {
        return this.useByteBuf;
    }

    public void setUseByteBuf(boolean useByteBuf) {
        this.useByteBuf = useByteBuf;
    }

    public boolean isUdpByteArrayCodec() {
        return this.udpByteArrayCodec;
    }

    public void setUdpByteArrayCodec(boolean udpByteArrayCodec) {
        this.udpByteArrayCodec = udpByteArrayCodec;
    }

    public boolean isReuseChannel() {
        return this.reuseChannel;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public NettyCamelStateCorrelationManager getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(NettyCamelStateCorrelationManager correlationManager) {
        this.correlationManager = correlationManager;
    }

    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    private static <T> void addToHandlersList(List<T> configured, List<T> handlers, Class<T> handlerType) {
        if (handlers != null) {
            for (T handler : handlers) {
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }
}

