/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.ReceiverContext;
import io.micrometer.observation.transport.RequestReplyReceiverContext;
import io.micrometer.observation.transport.RequestReplySenderContext;
import io.micrometer.observation.transport.SenderContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.observation.MicrometerObservationSpanAdapter;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;

@ManagedResource(description="MicrometerObservationTracer")
public class MicrometerObservationTracer
extends Tracer {
    static final String SPAN_DECORATOR_INTERNAL = "camel.micrometer.abstract-internal";
    private static final String CAMEL_CONTEXT_NAME = "camel.component";
    private io.micrometer.tracing.Tracer tracer = io.micrometer.tracing.Tracer.NOOP;
    private ObservationRegistry observationRegistry;

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public io.micrometer.tracing.Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(io.micrometer.tracing.Tracer tracer) {
        this.tracer = tracer;
    }

    private Observation.Context spanKindToContextOnExtract(SpanKind kind, SpanDecorator sd, Exchange exchange) {
        ExtractAdapter adapter = sd.getExtractAdapter(exchange.getIn().getHeaders(), this.encoding);
        switch (kind) {
            case PRODUCER: {
                throw new UnsupportedOperationException("You can't extract when sending a message");
            }
            case SPAN_KIND_SERVER: {
                RequestReplyReceiverContext replyReceiverContext = new RequestReplyReceiverContext((carrier, key) -> {
                    Object val = adapter.get(key);
                    return val != null ? val.toString() : null;
                });
                replyReceiverContext.setResponse((Object)exchange.getMessage());
                replyReceiverContext.setCarrier((Object)exchange.getIn());
                return replyReceiverContext;
            }
            case CONSUMER: 
            case SPAN_KIND_CLIENT: {
                ReceiverContext receiverContext = new ReceiverContext((carrier, key) -> {
                    Object val = adapter.get(key);
                    return val != null ? val.toString() : null;
                });
                receiverContext.setCarrier((Object)exchange.getIn());
                return receiverContext;
            }
        }
        return new Observation.Context();
    }

    private Observation.Context spanKindToContextOnInject(SpanKind kind, InjectAdapter adapter, Exchange exchange) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                RequestReplySenderContext senderContext = new RequestReplySenderContext((carrier, key, value) -> adapter.put(key, value));
                senderContext.setResponse((Object)exchange.getMessage());
                senderContext.setCarrier((Object)exchange.getIn());
                return senderContext;
            }
            case PRODUCER: {
                SenderContext context = new SenderContext((carrier, key, value) -> adapter.put(key, value));
                context.setCarrier((Object)exchange.getIn());
                return context;
            }
            case SPAN_KIND_SERVER: 
            case CONSUMER: {
                throw new UnsupportedOperationException("You can't inject when receiving a message");
            }
        }
        return new Observation.Context();
    }

    protected void initTracer() {
        Set tracers;
        Set registries;
        if (this.observationRegistry == null && (registries = this.getCamelContext().getRegistry().findByType(ObservationRegistry.class)).size() == 1) {
            this.observationRegistry = (ObservationRegistry)registries.iterator().next();
        }
        if (this.tracer == null && (tracers = this.getCamelContext().getRegistry().findByType(io.micrometer.tracing.Tracer.class)).size() == 1) {
            this.tracer = (io.micrometer.tracing.Tracer)tracers.iterator().next();
        }
        if (this.observationRegistry == null) {
            this.observationRegistry = ObservationRegistry.NOOP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpanAdapter startSendingEventSpan(String operationName, SpanKind kind, SpanAdapter parent, Exchange exchange, InjectAdapter injectAdapter) {
        Observation.Context context = this.spanKindToContextOnInject(kind, injectAdapter, exchange);
        Observation observation = Observation.createNotStarted((String)CAMEL_CONTEXT_NAME, () -> context, (ObservationRegistry)this.observationRegistry);
        observation.contextualName(operationName);
        Observation parentObservation = MicrometerObservationTracer.getParentObservation(parent);
        try (Tracer.SpanInScope scope = null;){
            TracingObservationHandler.TracingContext tracingContext;
            if (parentObservation != null && parentObservation != this.observationRegistry.getCurrentObservation() && (tracingContext = (TracingObservationHandler.TracingContext)parentObservation.getContextView().get(TracingObservationHandler.TracingContext.class)) != null) {
                Span parentSpan = tracingContext.getSpan();
                scope = this.tracer.withSpan(parentSpan);
            }
            if (parentObservation != null) {
                observation.parentObservation(parentObservation);
            }
            MicrometerObservationSpanAdapter micrometerObservationSpanAdapter = new MicrometerObservationSpanAdapter(observation.start(), this.tracer);
            return micrometerObservationSpanAdapter;
        }
    }

    private static Observation getParentObservation(SpanAdapter parentObservation) {
        if (parentObservation == null) {
            return null;
        }
        MicrometerObservationSpanAdapter observationWrapper = (MicrometerObservationSpanAdapter)parentObservation;
        return observationWrapper.getMicrometerObservation();
    }

    protected SpanAdapter startExchangeBeginSpan(Exchange exchange, SpanDecorator sd, String operationName, SpanKind kind, SpanAdapter parent) {
        boolean parentPresent = parent != null;
        Observation.Context context = this.spanKindToContextOnExtract(kind, sd, exchange);
        boolean internalSpanDecorator = sd instanceof AbstractInternalSpanDecorator;
        context.put((Object)SPAN_DECORATOR_INTERNAL, (Object)internalSpanDecorator);
        Observation observation = Observation.createNotStarted((String)operationName, () -> context, (ObservationRegistry)this.observationRegistry);
        if (parentPresent) {
            observation.parentObservation(MicrometerObservationTracer.getParentObservation(parent));
        }
        return new MicrometerObservationSpanAdapter(observation.start(), this.tracer);
    }

    protected void finishSpan(SpanAdapter span) {
        MicrometerObservationSpanAdapter observationSpanAdapter = (MicrometerObservationSpanAdapter)span;
        observationSpanAdapter.getMicrometerObservation().stop();
    }

    protected void inject(SpanAdapter span, InjectAdapter adapter) {
    }
}

