/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo4.Olingo4Configuration;
import org.apache.camel.component.olingo4.Olingo4Endpoint;
import org.apache.camel.component.olingo4.Olingo4Index;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.component.olingo4.internal.Olingo4ApiName;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.core.domain.ClientPrimitiveValueImpl;
import org.apache.olingo.client.core.domain.ClientPropertyImpl;

public class Olingo4Consumer
extends AbstractApiConsumer<Olingo4ApiName, Olingo4Configuration> {
    private Olingo4Index resultIndex;

    public Olingo4Consumer(Olingo4Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>(this.endpoint.getEndpointProperties());
        this.endpoint.interceptProperties(args);
        this.interceptProperties(args);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final Object[] result = new Object[1];
            final Exception[] error = new Exception[1];
            args.put("responseHandler", new Olingo4ResponseHandler<Object>(){

                public void onResponse(Object response, Map<String, String> responseHeaders) {
                    if (Olingo4Consumer.this.resultIndex != null) {
                        response = Olingo4Consumer.this.resultIndex.filterResponse(response);
                    }
                    result[0] = response;
                    latch.countDown();
                }

                public void onException(Exception ex) {
                    error[0] = ex;
                    latch.countDown();
                }

                public void onCanceled() {
                    error[0] = new RuntimeCamelException("OData HTTP Request cancelled");
                    latch.countDown();
                }
            });
            this.doInvokeMethod(args);
            latch.await();
            if (error[0] != null) {
                throw error[0];
            }
            if (result[0] == null || result[0] instanceof ClientEntitySet && ((ClientEntitySet)result[0]).getEntities().isEmpty()) {
                return 0;
            }
            return ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)result[0], (boolean)this.isSplitResult());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void interceptProperties(Map<String, Object> properties) {
        Object value = properties.get("filterAlreadySeen");
        if (value == null) {
            return;
        }
        if (Boolean.parseBoolean(value.toString()) && this.resultIndex == null) {
            this.resultIndex = new Olingo4Index();
        }
    }

    public void interceptResult(Object result, Exchange resultExchange) {
        if (this.resultIndex == null) {
            return;
        }
        this.resultIndex.index(result);
    }

    public Object splitResult(Object result) {
        ArrayList<Object> splitResult = new ArrayList<Object>();
        if (result instanceof ClientEntitySet) {
            ClientEntitySet entitySet = (ClientEntitySet)result;
            for (ClientEntity entity : entitySet.getEntities()) {
                if (entitySet.getCount() != null) {
                    ClientPrimitiveValue value = new ClientPrimitiveValueImpl.BuilderImpl().buildInt32(entitySet.getCount());
                    entity.getProperties().add(new ClientPropertyImpl("ResultCount", (ClientValue)value));
                }
                splitResult.add(entity);
            }
        } else if (result instanceof ClientValue && ((ClientValue)result).isCollection()) {
            ClientValue value = (ClientValue)result;
            ClientCollectionValue collection = value.asCollection();
            collection.forEach(v -> splitResult.add(v));
        } else {
            splitResult.add(result);
        }
        return splitResult;
    }
}

