/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.plc4x.Plc4XConsumer;
import org.apache.camel.component.plc4x.Plc4XPollingConsumer;
import org.apache.camel.component.plc4x.Plc4XProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.plc4x.java.DefaultPlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="plc4x", firstVersion="3.20.0", title="PLC4X", syntax="plc4x:driver", category={Category.IOT})
public class Plc4XEndpoint
extends DefaultEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XEndpoint.class);
    protected DefaultPlcDriverManager plcDriverManager = new DefaultPlcDriverManager();
    protected PlcConnection connection;
    @UriPath
    @Metadata(required=true, description="PLC4X connection string for the connection to the target")
    private String driver;
    @UriParam(label="consumer", prefix="tag.", multiValue=true)
    @Metadata(description="Tags as key/values from the Map to use in query")
    private Map<String, String> tags;
    @UriParam
    @Metadata(label="consumer", description="Query to a trigger. On a rising edge of the trigger, the tags will be read once")
    private String trigger;
    @UriParam
    @Metadata(label="consumer", description="Interval on which the Trigger should be checked")
    private int period;
    @UriParam
    @Metadata(description="Whether to reconnect when no connection is present upon doing a request")
    private boolean autoReconnect;
    private String uri;

    public Plc4XEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.uri = endpointUri.replaceFirst("plc4x:/?/?", "");
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
        this.plcDriverManager = new DefaultPlcDriverManager();
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setupConnection() throws PlcConnectionException {
        try {
            this.connection = this.plcDriverManager.getConnection(this.uri);
            if (!this.connection.isConnected()) {
                this.reconnectIfNeeded();
            }
        }
        catch (PlcConnectionException e) {
            if (this.isAutoReconnect()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.warn("Could not connect during setup, retrying on next request", (Throwable)e);
                } else {
                    LOGGER.warn("Could not connect during setup, retrying on next request");
                }
            }
            LOGGER.warn("Could not connect during setup and auto reconnect is turned off");
            throw e;
        }
    }

    public void reconnectIfNeeded() throws PlcConnectionException {
        if (this.connection != null && this.connection.isConnected()) {
            LOGGER.trace("No reconnect needed, already connected");
        } else if (this.autoReconnect && this.connection == null) {
            this.connection = this.plcDriverManager.getConnection(this.uri);
            LOGGER.debug("Successfully reconnected");
        } else if (this.autoReconnect && !this.connection.isConnected()) {
            this.connection.connect();
            if (!this.connection.isConnected()) {
                LOGGER.debug("No connection established after connect, resetting connection");
                this.connection = this.plcDriverManager.getConnection(this.uri);
            }
            LOGGER.debug("Successfully reconnected");
        } else {
            LOGGER.warn("Connection lost and auto-reconnect is turned off, shutting down Plc4XEndpoint");
            this.stop();
        }
    }

    public boolean canWrite() {
        return this.connection.getMetadata().isWriteSupported();
    }

    public Producer createProducer() {
        return new Plc4XProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Plc4XConsumer consumer = new Plc4XConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PollingConsumer createPollingConsumer() {
        return new Plc4XPollingConsumer(this);
    }

    public PlcReadRequest buildPlcReadRequest() {
        PlcReadRequest.Builder builder = this.connection.readRequestBuilder();
        if (this.tags != null) {
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                try {
                    builder.addTagAddress(tag.getKey(), tag.getValue());
                }
                catch (PlcIncompatibleDatatypeException e) {
                    LOGGER.warn("For consumer, please use Map<String,String>, currently using {}", (Object)this.tags.getClass().getSimpleName());
                }
            }
        }
        return builder.build();
    }

    public PlcWriteRequest buildPlcWriteRequest(Map<String, Map<String, Object>> tags) {
        PlcWriteRequest.Builder builder = this.connection.writeRequestBuilder();
        for (Map.Entry<String, Map<String, Object>> entry : tags.entrySet()) {
            String name = entry.getKey();
            String query = entry.getValue().keySet().iterator().next();
            Object value = entry.getValue().get(query);
            builder.addTagAddress(name, query, new Object[]{value});
        }
        return builder.build();
    }

    public DefaultPlcDriverManager getPlcDriverManager() {
        return this.plcDriverManager;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void doStop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.close();
            this.connection = null;
        }
    }
}

