/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultMessage;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;

public class QuartzMessage
extends DefaultMessage {
    private final JobExecutionContext jobExecutionContext;

    public QuartzMessage(Exchange exchange, JobExecutionContext jobExecutionContext) {
        this.jobExecutionContext = jobExecutionContext;
        this.setExchange(exchange);
    }

    public JobExecutionContext getJobExecutionContext() {
        return this.jobExecutionContext;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        super.populateInitialHeaders(map);
        if (this.jobExecutionContext != null) {
            map.put("calendar", this.jobExecutionContext.getCalendar());
            map.put("fireTime", this.jobExecutionContext.getFireTime());
            map.put("jobDetail", this.jobExecutionContext.getJobDetail());
            map.put("jobInstance", this.jobExecutionContext.getJobInstance());
            map.put("jobRunTime", this.jobExecutionContext.getJobRunTime());
            map.put("mergedJobDataMap", this.jobExecutionContext.getMergedJobDataMap());
            map.put("nextFireTime", this.jobExecutionContext.getNextFireTime());
            map.put("previousFireTime", this.jobExecutionContext.getPreviousFireTime());
            map.put("refireCount", this.jobExecutionContext.getRefireCount());
            map.put("result", this.jobExecutionContext.getResult());
            map.put("scheduledFireTime", this.jobExecutionContext.getScheduledFireTime());
            map.put("scheduler", this.jobExecutionContext.getScheduler());
            Trigger trigger = this.jobExecutionContext.getTrigger();
            map.put("trigger", trigger);
            map.put("triggerName", trigger.getKey().getName());
            map.put("triggerGroup", trigger.getKey().getGroup());
        }
    }
}

