/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.util.Collection;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.QuartzEndpoint;
import org.apache.camel.component.quartz2.QuartzMessage;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(CamelJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Exchange exchange = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running CamelJob jobExecutionContext={}", (Object)context);
            }
            CamelContext camelContext = this.getCamelContext(context);
            QuartzEndpoint endpoint = this.lookupQuartzEndpoint(camelContext, context);
            exchange = endpoint.createExchange();
            exchange.setIn((Message)new QuartzMessage(exchange, context));
            AsyncProcessor processor = endpoint.getProcessor();
            try {
                if (processor != null) {
                    processor.process(exchange);
                } else {
                    LOG.debug("Cannot execute CamelJob as there are no active consumers.");
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            if (exchange.getException() != null) {
                throw new JobExecutionException((Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            if (exchange != null) {
                LOG.error(CamelExchangeException.createExceptionMessage((String)"Error processing exchange", exchange, (Throwable)e));
            } else {
                LOG.error("Failed to execute CamelJob.", (Throwable)e);
            }
            if (e instanceof JobExecutionException) {
                throw (JobExecutionException)e;
            }
            throw new JobExecutionException((Throwable)e);
        }
    }

    protected CamelContext getCamelContext(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = this.getSchedulerContext(context);
        String camelContextName = context.getMergedJobDataMap().getString("CamelQuartzCamelContextName");
        CamelContext result = (CamelContext)schedulerContext.get((Object)("CamelQuartzCamelContext-" + camelContextName));
        if (result == null) {
            throw new JobExecutionException("No CamelContext could be found with name: " + camelContextName);
        }
        return result;
    }

    protected SchedulerContext getSchedulerContext(JobExecutionContext context) throws JobExecutionException {
        try {
            return context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + context.getJobDetail().getKey());
        }
    }

    protected QuartzEndpoint lookupQuartzEndpoint(CamelContext camelContext, JobExecutionContext quartzContext) throws JobExecutionException {
        QuartzEndpoint result;
        TriggerKey triggerKey = quartzContext.getTrigger().getKey();
        JobDetail jobDetail = quartzContext.getJobDetail();
        JobKey jobKey = jobDetail.getKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up existing QuartzEndpoint with triggerKey={}", (Object)triggerKey);
        }
        for (Route route : camelContext.getRoutes()) {
            Endpoint endpoint = route.getEndpoint();
            if (endpoint instanceof DelegateEndpoint) {
                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
            }
            if (!(endpoint instanceof QuartzEndpoint)) continue;
            QuartzEndpoint quartzEndpoint = (QuartzEndpoint)endpoint;
            TriggerKey checkTriggerKey = quartzEndpoint.getTriggerKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Checking route endpoint={} with checkTriggerKey={}", (Object)quartzEndpoint, (Object)checkTriggerKey);
            }
            if (!triggerKey.equals((Object)checkTriggerKey) && (!jobDetail.requestsRecovery() || !jobKey.getGroup().equals(checkTriggerKey.getGroup()) || !jobKey.getName().equals(checkTriggerKey.getName()))) continue;
            return quartzEndpoint;
        }
        String endpointUri = quartzContext.getMergedJobDataMap().getString("CamelQuartzEndpoint");
        if (camelContext.hasEndpoint(endpointUri) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting Endpoint from camelContext.");
            }
            result = (QuartzEndpoint)camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
        } else {
            result = this.searchForEndpointMatch(camelContext, endpointUri);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found match for endpoint URI = {} by searching endpoint list.", (Object)endpointUri);
                }
            } else {
                LOG.warn("Cannot find existing QuartzEndpoint with uri: {}. Creating new endpoint instance.", (Object)endpointUri);
                result = (QuartzEndpoint)camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
            }
        }
        if (result == null) {
            throw new JobExecutionException("No QuartzEndpoint could be found with endpointUri: " + endpointUri);
        }
        return result;
    }

    protected QuartzEndpoint searchForEndpointMatch(CamelContext camelContext, String endpointUri) {
        Collection endpoints = camelContext.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (!endpointUri.equals(endpoint.getEndpointUri())) continue;
            return (QuartzEndpoint)endpoint;
        }
        return null;
    }
}

