/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="rabbitmq")
public class RabbitMQComponent
extends DefaultComponent {
    public static final String ARG_PREFIX = "arg.";
    public static final String EXCHANGE_ARG_PREFIX = "exchange.";
    public static final String QUEUE_ARG_PREFIX = "queue.";
    public static final String BINDING_ARG_PREFIX = "binding.";
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQComponent.class);
    @Metadata(label="common")
    private String hostname;
    @Metadata(label="common", defaultValue="5672")
    private int portNumber;
    @Metadata(label="security", defaultValue="guest", secret=true)
    private String username = "guest";
    @Metadata(label="security", defaultValue="guest", secret=true)
    private String password = "guest";
    @Metadata(label="common", defaultValue="/")
    private String vhost = "/";
    @Metadata(label="common")
    private String addresses;
    @Metadata(label="common")
    private ConnectionFactory connectionFactory;
    @Metadata(label="consumer", defaultValue="true")
    private boolean autoAck = true;
    @Metadata(label="common", defaultValue="true")
    private boolean autoDelete = true;
    @Metadata(label="common", defaultValue="true")
    private boolean durable = true;
    @Metadata(label="consumer")
    private boolean exclusiveConsumer;
    @Metadata(label="common")
    private boolean exclusive;
    @Metadata(label="common")
    private boolean passive;
    @Metadata(label="common", defaultValue="true")
    private boolean declare = true;
    @Metadata(label="common")
    private boolean skipQueueDeclare;
    @Metadata(label="common")
    private boolean skipQueueBind;
    @Metadata(label="common")
    private boolean skipExchangeDeclare;
    @Metadata(label="common")
    private String deadLetterExchange;
    @Metadata(label="common")
    private String deadLetterRoutingKey;
    @Metadata(label="common")
    private String deadLetterQueue;
    @Metadata(label="common", defaultValue="direct", enums="direct,fanout,headers,topic")
    private String deadLetterExchangeType = "direct";
    @Metadata(label="producer")
    private boolean allowNullHeaders;
    @Metadata(label="security")
    private String sslProtocol;
    @Metadata(label="security")
    private TrustManager trustManager;
    @Metadata(label="consumer,advanced", defaultValue="10")
    private int threadPoolSize = 10;
    @Metadata(label="advanced", defaultValue="true")
    private boolean autoDetectConnectionFactory = true;
    @Metadata(label="advanced", defaultValue="60000")
    private int connectionTimeout = 60000;
    @Metadata(label="advanced", defaultValue="2047")
    private int requestedChannelMax = 2047;
    @Metadata(label="advanced", defaultValue="0")
    private int requestedFrameMax = 0;
    @Metadata(label="advanced", defaultValue="60")
    private int requestedHeartbeat = 60;
    @Metadata(label="advanced")
    private Boolean automaticRecoveryEnabled;
    @Metadata(label="advanced", defaultValue="5000")
    private Integer networkRecoveryInterval = 5000;
    @Metadata(label="advanced")
    private Boolean topologyRecoveryEnabled;
    @Metadata(label="consumer")
    private boolean prefetchEnabled;
    @Metadata(label="consumer")
    private int prefetchSize;
    @Metadata(label="consumer")
    private int prefetchCount;
    @Metadata(label="consumer")
    private boolean prefetchGlobal;
    @Metadata(label="producer", defaultValue="10")
    private int channelPoolMaxSize = 10;
    @Metadata(label="producer", defaultValue="1000")
    private long channelPoolMaxWait = 1000L;
    @Metadata(label="advanced", defaultValue="20000")
    private long requestTimeout = 20000L;
    @Metadata(label="advanced", defaultValue="1000")
    private long requestTimeoutCheckerInterval = 1000L;
    @Metadata(label="advanced")
    private boolean transferException;
    @Metadata(label="producer")
    private boolean mandatory;
    @Metadata(label="producer")
    private boolean immediate;
    @Metadata(label="producer")
    private boolean publisherAcknowledgements;
    @Metadata(label="producer")
    private long publisherAcknowledgementsTimeout;
    @Metadata(label="producer")
    private boolean guaranteedDeliveries;
    @Metadata(label="advanced")
    private Map<String, Object> args;
    @Metadata(label="advanced")
    private Map<String, Object> clientProperties;

    public RabbitMQComponent() {
    }

    public RabbitMQComponent(CamelContext context) {
        super(context);
    }

    protected RabbitMQEndpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        Map map;
        ConnectionFactory connectionFactory;
        String host = this.getHostname();
        int port = this.getPortNumber();
        String exchangeName = remaining;
        if (remaining.contains(":") || remaining.contains("/")) {
            LOG.warn("The old syntax rabbitmq://hostname:port/exchangeName is deprecated. You should configure the hostname on the component or ConnectionFactory");
            try {
                URI u = new URI("http://" + remaining);
                host = u.getHost();
                port = u.getPort();
                exchangeName = u.getPath().trim().length() > 1 ? u.getPath().substring(1) : "";
            }
            catch (Throwable u) {
                // empty catch block
            }
        }
        if ((connectionFactory = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(params, "connectionFactory", ConnectionFactory.class, this.getConnectionFactory())) == null && this.isAutoDetectConnectionFactory() && (map = this.getCamelContext().getRegistry().findByTypeWithName(ConnectionFactory.class)) != null && map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            connectionFactory = (ConnectionFactory)entry.getValue();
            String name = (String)entry.getKey();
            if (name == null) {
                name = "anonymous";
            }
            LOG.info("Auto-detected single instance: {} of type ConnectionFactory in Registry to be used as ConnectionFactory when creating endpoint: {}", (Object)name, (Object)uri);
        }
        Map clientProperties = (Map)this.resolveAndRemoveReferenceParameter(params, "clientProperties", Map.class, this.getClientProperties());
        TrustManager trustManager = (TrustManager)this.resolveAndRemoveReferenceParameter(params, "trustManager", TrustManager.class, this.getTrustManager());
        RabbitMQEndpoint endpoint = connectionFactory == null ? new RabbitMQEndpoint(uri, this) : new RabbitMQEndpoint(uri, this, connectionFactory);
        endpoint.setHostname(host);
        endpoint.setPortNumber(port);
        endpoint.setUsername(this.getUsername());
        endpoint.setPassword(this.getPassword());
        endpoint.setVhost(this.getVhost());
        endpoint.setAddresses(this.getAddresses());
        endpoint.setThreadPoolSize(this.getThreadPoolSize());
        endpoint.setExchangeName(exchangeName);
        endpoint.setClientProperties(clientProperties);
        endpoint.setSslProtocol(this.getSslProtocol());
        endpoint.setTrustManager(trustManager);
        endpoint.setConnectionTimeout(this.getConnectionTimeout());
        endpoint.setRequestedChannelMax(this.getRequestedChannelMax());
        endpoint.setRequestedFrameMax(this.getRequestedFrameMax());
        endpoint.setRequestedHeartbeat(this.getRequestedHeartbeat());
        endpoint.setAutomaticRecoveryEnabled(this.getAutomaticRecoveryEnabled());
        endpoint.setNetworkRecoveryInterval(this.getNetworkRecoveryInterval());
        endpoint.setTopologyRecoveryEnabled(this.getTopologyRecoveryEnabled());
        endpoint.setPrefetchEnabled(this.isPrefetchEnabled());
        endpoint.setPrefetchSize(this.getPrefetchSize());
        endpoint.setPrefetchCount(this.getPrefetchCount());
        endpoint.setPrefetchGlobal(this.isPrefetchGlobal());
        endpoint.setChannelPoolMaxSize(this.getChannelPoolMaxSize());
        endpoint.setChannelPoolMaxWait(this.getChannelPoolMaxWait());
        endpoint.setRequestTimeout(this.getRequestTimeout());
        endpoint.setRequestTimeoutCheckerInterval(this.getRequestTimeoutCheckerInterval());
        endpoint.setTransferException(this.isTransferException());
        endpoint.setPublisherAcknowledgements(this.isPublisherAcknowledgements());
        endpoint.setPublisherAcknowledgementsTimeout(this.getPublisherAcknowledgementsTimeout());
        endpoint.setGuaranteedDeliveries(this.isGuaranteedDeliveries());
        endpoint.setMandatory(this.isMandatory());
        endpoint.setImmediate(this.isImmediate());
        endpoint.setAutoAck(this.isAutoAck());
        endpoint.setAutoDelete(this.isAutoDelete());
        endpoint.setDurable(this.isDurable());
        endpoint.setExclusive(this.isExclusive());
        endpoint.setExclusiveConsumer(this.isExclusiveConsumer());
        endpoint.setPassive(this.isPassive());
        endpoint.setSkipExchangeDeclare(this.isSkipExchangeDeclare());
        endpoint.setSkipQueueBind(this.isSkipQueueBind());
        endpoint.setSkipQueueDeclare(this.isSkipQueueDeclare());
        endpoint.setDeclare(this.isDeclare());
        endpoint.setDeadLetterExchange(this.getDeadLetterExchange());
        endpoint.setDeadLetterExchangeType(this.getDeadLetterExchangeType());
        endpoint.setDeadLetterQueue(this.getDeadLetterQueue());
        endpoint.setDeadLetterRoutingKey(this.getDeadLetterRoutingKey());
        endpoint.setAllowNullHeaders(this.isAllowNullHeaders());
        this.setProperties((Endpoint)endpoint, params);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RabbitMQEndpoint with host {}:{} and exchangeName: {}", new Object[]{endpoint.getHostname(), endpoint.getPortNumber(), endpoint.getExchangeName()});
        }
        HashMap<String, Object> localArgs = new HashMap<String, Object>();
        if (this.getArgs() != null) {
            localArgs.putAll(this.getArgs());
        }
        localArgs.putAll(PropertiesHelper.extractProperties(params, (String)ARG_PREFIX));
        Map<String, Object> existing = endpoint.getArgs();
        if (existing != null) {
            existing.putAll(localArgs);
        } else {
            endpoint.setArgs(localArgs);
        }
        endpoint.getMessageConverter().setAllowNullHeaders(endpoint.isAllowNullHeaders());
        return endpoint;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public boolean isAutoDetectConnectionFactory() {
        return this.autoDetectConnectionFactory;
    }

    public void setAutoDetectConnectionFactory(boolean autoDetectConnectionFactory) {
        this.autoDetectConnectionFactory = autoDetectConnectionFactory;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public Boolean getAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public void setAutomaticRecoveryEnabled(Boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public Boolean getTopologyRecoveryEnabled() {
        return this.topologyRecoveryEnabled;
    }

    public void setTopologyRecoveryEnabled(Boolean topologyRecoveryEnabled) {
        this.topologyRecoveryEnabled = topologyRecoveryEnabled;
    }

    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchGlobal(boolean prefetchGlobal) {
        this.prefetchGlobal = prefetchGlobal;
    }

    public boolean isPrefetchGlobal() {
        return this.prefetchGlobal;
    }

    public int getChannelPoolMaxSize() {
        return this.channelPoolMaxSize;
    }

    public void setChannelPoolMaxSize(int channelPoolMaxSize) {
        this.channelPoolMaxSize = channelPoolMaxSize;
    }

    public long getChannelPoolMaxWait() {
        return this.channelPoolMaxWait;
    }

    public void setChannelPoolMaxWait(long channelPoolMaxWait) {
        this.channelPoolMaxWait = channelPoolMaxWait;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public boolean isPublisherAcknowledgements() {
        return this.publisherAcknowledgements;
    }

    public void setPublisherAcknowledgements(boolean publisherAcknowledgements) {
        this.publisherAcknowledgements = publisherAcknowledgements;
    }

    public long getPublisherAcknowledgementsTimeout() {
        return this.publisherAcknowledgementsTimeout;
    }

    public void setPublisherAcknowledgementsTimeout(long publisherAcknowledgementsTimeout) {
        this.publisherAcknowledgementsTimeout = publisherAcknowledgementsTimeout;
    }

    public boolean isGuaranteedDeliveries() {
        return this.guaranteedDeliveries;
    }

    public void setGuaranteedDeliveries(boolean guaranteedDeliveries) {
        this.guaranteedDeliveries = guaranteedDeliveries;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(boolean exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setSkipQueueDeclare(boolean skipQueueDeclare) {
        this.skipQueueDeclare = skipQueueDeclare;
    }

    public boolean isSkipQueueDeclare() {
        return this.skipQueueDeclare;
    }

    public boolean isSkipQueueBind() {
        return this.skipQueueBind;
    }

    public void setSkipQueueBind(boolean skipQueueBind) {
        this.skipQueueBind = skipQueueBind;
    }

    public void setSkipExchangeDeclare(boolean skipExchangeDeclare) {
        this.skipExchangeDeclare = skipExchangeDeclare;
    }

    public boolean isSkipExchangeDeclare() {
        return this.skipExchangeDeclare;
    }

    public boolean isDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean declare) {
        this.declare = declare;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public boolean isAllowNullHeaders() {
        return this.allowNullHeaders;
    }

    public void setAllowNullHeaders(boolean allowNullHeaders) {
        this.allowNullHeaders = allowNullHeaders;
    }
}

