/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.rabbitmq.RabbitConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQConsumer.class);
    private ExecutorService executor;
    private Connection conn;
    private int closeTimeout = 30000;
    private final RabbitMQEndpoint endpoint;
    private StartConsumerCallable startConsumerCallable;
    private final List<RabbitConsumer> consumers = new ArrayList<RabbitConsumer>();

    public RabbitMQConsumer(RabbitMQEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public RabbitMQEndpoint getEndpoint() {
        return (RabbitMQEndpoint)super.getEndpoint();
    }

    private void openConnection() throws IOException, TimeoutException {
        LOG.trace("Creating connection...");
        this.conn = this.getEndpoint().connect(this.executor);
        LOG.debug("Created connection: {}", (Object)this.conn);
    }

    protected synchronized Connection getConnection() throws IOException, TimeoutException {
        if (this.conn == null || !this.conn.isOpen()) {
            LOG.debug("The existing connection is closed or not opened yet.");
            this.openConnection();
            return this.conn;
        }
        return this.conn;
    }

    private void createConsumers() {
        for (int i = 0; i < this.endpoint.getConcurrentConsumers(); ++i) {
            this.createConsumer();
        }
    }

    private void startConsumers() {
        Exception fail = null;
        for (RabbitConsumer consumer : this.consumers) {
            try {
                ServiceHelper.startService((Object)((Object)consumer));
            }
            catch (Exception e) {
                fail = e;
            }
        }
        if (fail != null) {
            LOG.info("Connection failed starting consumers, will start background thread to retry!", fail);
            this.reconnect();
        }
    }

    private void createConsumer() {
        RabbitConsumer consumer = new RabbitConsumer(this);
        this.consumers.add(consumer);
    }

    public Exchange createExchange(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        Exchange exchange = this.createExchange(false);
        this.endpoint.getMessageConverter().populateRabbitExchange(exchange, envelope, properties, body, false, this.endpoint.isAllowMessageBodySerialization());
        return exchange;
    }

    private synchronized void reconnect() {
        if (this.startConsumerCallable != null) {
            return;
        }
        Integer networkRecoveryInterval = this.getEndpoint().getNetworkRecoveryInterval();
        long connectionRetryInterval = networkRecoveryInterval != null && networkRecoveryInterval > 0 ? (long)networkRecoveryInterval.intValue() : 100L;
        this.startConsumerCallable = new StartConsumerCallable(connectionRetryInterval);
        this.executor.submit(this.startConsumerCallable);
    }

    private void closeConnectionAndChannel() throws IOException {
        if (this.startConsumerCallable != null) {
            this.startConsumerCallable.stop();
        }
        for (RabbitConsumer consumer : this.consumers) {
            try {
                consumer.cancelChannel();
            }
            catch (Exception e) {
                LOG.warn("Error occurred while cancelling consumer. This exception is ignored", (Throwable)e);
            }
        }
        for (RabbitConsumer consumer : this.consumers) {
            try {
                ServiceHelper.stopAndShutdownService((Object)((Object)consumer));
            }
            catch (Exception e) {
                LOG.warn("Error occurred while stopping consumer. This exception is ignored", (Throwable)e);
            }
        }
        this.consumers.clear();
        if (this.conn != null) {
            LOG.debug("Closing connection: {} with timeout: {} ms.", (Object)this.conn, (Object)this.closeTimeout);
            this.conn.close(this.closeTimeout);
            this.conn = null;
        }
    }

    protected void doSuspend() throws Exception {
        this.closeConnectionAndChannel();
    }

    protected void doResume() throws Exception {
        this.createConsumers();
        this.startConsumers();
    }

    protected void doStart() throws Exception {
        this.executor = this.endpoint.createExecutor();
        LOG.debug("Using executor {}", (Object)this.executor);
        this.createConsumers();
        this.startConsumers();
    }

    protected void doStop() throws Exception {
        this.closeConnectionAndChannel();
        if (this.executor != null) {
            if (this.endpoint != null && this.endpoint.getCamelContext() != null) {
                this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
            this.executor = null;
        }
    }

    private class StartConsumerCallable
    implements Callable<Void> {
        private final long connectionRetryInterval;
        private final AtomicBoolean running = new AtomicBoolean(true);

        StartConsumerCallable(long connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public void stop() {
            this.running.set(false);
            RabbitMQConsumer.this.startConsumerCallable = null;
        }

        private boolean reconnect() {
            if (!this.running.get()) {
                return true;
            }
            try {
                for (RabbitConsumer consumer : RabbitMQConsumer.this.consumers) {
                    consumer.reconnect();
                }
                return true;
            }
            catch (Exception e) {
                LOG.info("Connection failed, will retry in {} ms", (Object)this.connectionRetryInterval, (Object)e);
                return false;
            }
        }

        @Override
        public Void call() throws Exception {
            BlockingTask task = (BlockingTask)Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withInterval(Duration.ofMillis(this.connectionRetryInterval)).withMaxIterations(-1).build()).withName("rabbitmq-reconnection-loop").build();
            task.run(this::reconnect);
            return null;
        }
    }
}

