/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rabbitmq.RabbitMQConstants;
import org.apache.camel.component.rabbitmq.RabbitMQHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessageConverter {
    protected static final Logger LOG = LoggerFactory.getLogger(RabbitMQMessageConverter.class);
    private boolean allowNullHeaders;
    private boolean allowCustomHeaders;
    private Map<String, Object> additionalHeaders;
    private Map<String, Object> additionalProperties;
    private final HeaderFilterStrategy headerFilterStrategy = new RabbitMQHeaderFilterStrategy();

    public void mergeAmqpProperties(Exchange exchange, AMQP.BasicProperties properties) {
        if (properties.getType() != null) {
            exchange.getIn().setHeader("CamelRabbitmqType", (Object)properties.getType());
        }
        if (properties.getAppId() != null) {
            exchange.getIn().setHeader("CamelRabbitmqAppId", (Object)properties.getAppId());
        }
        if (properties.getClusterId() != null) {
            exchange.getIn().setHeader("CamelRabbitmqClusterId", (Object)properties.getClusterId());
        }
        if (properties.getContentEncoding() != null) {
            exchange.getIn().setHeader("CamelRabbitmqContentEncoding", (Object)properties.getContentEncoding());
        }
        if (properties.getContentType() != null) {
            exchange.getIn().setHeader("CamelRabbitmqContentType", (Object)properties.getContentType());
        }
        if (properties.getCorrelationId() != null) {
            exchange.getIn().setHeader("CamelRabbitmqCorrelationId", (Object)properties.getCorrelationId());
        }
        if (properties.getExpiration() != null) {
            exchange.getIn().setHeader("CamelRabbitmqExpiration", (Object)properties.getExpiration());
        }
        if (properties.getMessageId() != null) {
            exchange.getIn().setHeader("CamelRabbitmqMessageId", (Object)properties.getMessageId());
        }
        if (properties.getPriority() != null) {
            exchange.getIn().setHeader("CamelRabbitmqPriority", (Object)properties.getPriority());
        }
        if (properties.getReplyTo() != null) {
            exchange.getIn().setHeader("CamelRabbitmqReplyTo", (Object)properties.getReplyTo());
        }
        if (properties.getTimestamp() != null) {
            exchange.getIn().setHeader("CamelRabbitmqTimestamp", (Object)properties.getTimestamp());
        }
        if (properties.getUserId() != null) {
            exchange.getIn().setHeader("CamelRabbitmqUserId", (Object)properties.getUserId());
        }
        if (properties.getDeliveryMode() != null) {
            exchange.getIn().setHeader("CamelRabbitmqDeliveryMode", (Object)properties.getDeliveryMode());
        }
    }

    public AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Message msg = exchange.getMessage();
        AMQP.BasicProperties.Builder properties = this.buildBasicAmqpProperties(exchange.getProperties(), msg);
        Map headers = properties.build().getHeaders();
        if (this.additionalHeaders != null) {
            headers.putAll(this.additionalHeaders);
        }
        HashMap filteredHeaders = new HashMap();
        for (Map.Entry header : headers.entrySet()) {
            Object value = this.getValidRabbitMQHeaderValue((String)header.getKey(), header.getValue());
            if ((value != null || this.isAllowNullHeaders()) && !((String)header.getKey()).equals("CamelRabbitmqExchangeOverrideName")) {
                if (!this.allowCustomHeaders) {
                    boolean filteredHeader = this.headerFilterStrategy.applyFilterToCamelHeaders((String)header.getKey(), header.getValue(), exchange);
                    if (!filteredHeader) continue;
                    filteredHeaders.put(header.getKey(), header.getValue());
                    continue;
                }
                filteredHeaders.put(header.getKey(), header.getValue());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            if (header.getValue() == null) {
                LOG.debug("Ignoring header: {} with null value", header.getKey());
                continue;
            }
            if (((String)header.getKey()).equals("CamelRabbitmqExchangeOverrideName")) {
                LOG.debug("Preventing header propagation: {} with value {}:", header.getKey(), header.getValue());
                continue;
            }
            LOG.debug("Ignoring header: {} of class: {} with value: {}", new Object[]{header.getKey(), ObjectHelper.classCanonicalName(header.getValue()), header.getValue()});
        }
        properties.headers(filteredHeaders);
        return properties;
    }

    private AMQP.BasicProperties.Builder buildBasicAmqpProperties(Map<String, Object> exchangeProperties, Message msg) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        HashMap<String, Object> headers = new HashMap<String, Object>(msg.getHeaders());
        Object contentType = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqContentType");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqPriority")) != null) {
            properties.priority(Integer.valueOf(Integer.parseInt(priority.toString())));
        }
        if ((messageId = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqMessageId")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqClusterId")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqReplyTo")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqCorrelationId")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqDeliveryMode")) != null) {
            properties.deliveryMode(Integer.valueOf(Integer.parseInt(deliveryMode.toString())));
        }
        if ((userId = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqUserId")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqType")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqContentEncoding")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqExpiration")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqAppId")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = this.getBasicAmqpProperty(exchangeProperties, headers, "CamelRabbitmqTimestamp")) != null) {
            properties.timestamp(this.convertTimestamp(timestamp));
        }
        String ignoredProperties = exchangeProperties.keySet().stream().filter(key -> !RabbitMQConstants.BASIC_AMQP_PROPERTIES.contains(key)).collect(Collectors.joining(", "));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added AMQP basic properties: {}", (Object)properties.build().toString());
            LOG.debug("Ignoring non-AMQP basic properties: {}", (Object)ignoredProperties);
        }
        properties.headers(headers);
        return properties;
    }

    private Object getBasicAmqpProperty(Map<String, Object> exchangeProperties, Map<String, Object> headers, String propertyKey) {
        boolean hasAdditionalProps = this.additionalProperties != null && !this.additionalProperties.isEmpty();
        Object object = headers.remove(propertyKey);
        if (exchangeProperties.containsKey(propertyKey)) {
            object = exchangeProperties.get(propertyKey);
        }
        if (object == null && hasAdditionalProps) {
            object = this.additionalProperties.get(propertyKey);
        }
        return object;
    }

    private Date convertTimestamp(Object timestamp) {
        if (timestamp instanceof Date) {
            return (Date)timestamp;
        }
        return new Date(Long.parseLong(timestamp.toString()));
    }

    private Object getValidRabbitMQHeaderValue(String headerKey, Object headerValue) {
        if (headerKey.startsWith("x-") || headerKey.startsWith("X-")) {
            return headerKey;
        }
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (headerValue instanceof byte[]) {
            return headerValue;
        }
        if (headerValue instanceof LongString) {
            return headerValue;
        }
        if (headerValue instanceof Map) {
            return headerValue;
        }
        if (headerValue instanceof List) {
            return headerValue;
        }
        return null;
    }

    public void populateRabbitExchange(Exchange camelExchange, Envelope envelope, AMQP.BasicProperties properties, byte[] body, boolean out, boolean allowMessageBodySerialization) {
        Message message = this.resolveMessageFrom(camelExchange, out);
        this.populateMessageHeaders(message, envelope, properties);
        this.populateMessageBody(message, camelExchange, properties, body, allowMessageBodySerialization);
    }

    private Message resolveMessageFrom(Exchange camelExchange, boolean out) {
        Message message;
        if (out) {
            message = camelExchange.getOut();
        } else if (camelExchange.getIn() != null) {
            message = camelExchange.getIn();
        } else {
            message = new DefaultMessage(camelExchange.getContext());
            camelExchange.setIn(message);
        }
        return message;
    }

    private void populateMessageHeaders(Message message, Envelope envelope, AMQP.BasicProperties properties) {
        this.populateRoutingInfoHeaders(message, envelope);
        this.populateMessageHeadersFromRabbitMQHeaders(message, properties);
    }

    private void populateRoutingInfoHeaders(Message message, Envelope envelope) {
        if (envelope != null) {
            message.setHeader("CamelRabbitmqRoutingKey", (Object)envelope.getRoutingKey());
            message.setHeader("CamelRabbitmqExchangeName", (Object)envelope.getExchange());
            message.setHeader("CamelRabbitmqDeliveryTag", (Object)envelope.getDeliveryTag());
            message.setHeader("CamelRabbitmqRedeliveryTag", (Object)envelope.isRedeliver());
        }
    }

    private void populateMessageHeadersFromRabbitMQHeaders(Message message, AMQP.BasicProperties properties) {
        Map headers = properties.getHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (entry.getValue() instanceof LongString) {
                    message.setHeader((String)entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                message.setHeader((String)entry.getKey(), entry.getValue());
            }
        }
        if (properties.getTimestamp() != null) {
            message.setHeader("CamelMessageTimestamp", (Object)properties.getTimestamp().getTime());
        }
    }

    private void populateMessageBody(Message message, Exchange camelExchange, AMQP.BasicProperties properties, byte[] body, boolean allowMessageBodySerialization) {
        if (allowMessageBodySerialization && this.hasSerializeHeader(properties)) {
            this.deserializeBody(camelExchange, message, body);
        } else {
            message.setBody((Object)body);
        }
    }

    private void deserializeBody(Exchange camelExchange, Message message, byte[] body) {
        Object messageBody = null;
        try (ByteArrayInputStream b = new ByteArrayInputStream(body);
             ObjectInputStream o = new ObjectInputStream(b);){
            messageBody = o.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warn("Could not deserialize the object");
            camelExchange.setException((Throwable)e);
        }
        if (messageBody instanceof Throwable) {
            LOG.debug("Reply was an Exception. Setting the Exception on the Exchange");
            camelExchange.setException((Throwable)messageBody);
        } else {
            message.setBody(messageBody);
        }
    }

    private boolean hasSerializeHeader(AMQP.BasicProperties properties) {
        return this.hasHeaders(properties) && Boolean.TRUE.equals(this.isSerializeHeaderEnabled(properties));
    }

    private boolean hasHeaders(AMQP.BasicProperties properties) {
        return properties != null && properties.getHeaders() != null;
    }

    private Object isSerializeHeaderEnabled(AMQP.BasicProperties properties) {
        return properties.getHeaders().get("CamelSerialize");
    }

    public boolean isAllowNullHeaders() {
        return this.allowNullHeaders;
    }

    public void setAllowNullHeaders(boolean allowNullHeaders) {
        this.allowNullHeaders = allowNullHeaders;
    }

    public boolean isAllowCustomHeaders() {
        return this.allowCustomHeaders;
    }

    public void setAllowCustomHeaders(boolean allowCustomHeaders) {
        this.allowCustomHeaders = allowCustomHeaders;
    }

    public void setAdditionalHeaders(Map<String, Object> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public Map<String, Object> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

