/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.util.Arrays;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.component.rss.RssConstants;
import org.apache.camel.component.rss.RssEntryPollingConsumer;
import org.apache.camel.component.rss.RssPollingConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.0.0", scheme="rss", extendsScheme="atom", title="RSS", syntax="rss:feedUri", consumerOnly=true, category={Category.RSS}, lenientProperties=true, headersClass=RssConstants.class)
public class RssEndpoint
extends FeedEndpoint {
    protected static final Logger LOG = LoggerFactory.getLogger(RssEndpoint.class);

    public RssEndpoint() {
    }

    public RssEndpoint(String endpointUri, FeedComponent component, String feedUri) {
        super(endpointUri, component, feedUri);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("RssProducer is not implemented");
    }

    public Exchange createExchange(Object feed) {
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelRssFeed");
        exchange.getIn().setBody(feed);
        return exchange;
    }

    public Exchange createExchange(Object feed, Object entry) {
        SyndFeed newFeed;
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelRssFeed");
        try {
            newFeed = (SyndFeed)((SyndFeed)feed).clone();
            newFeed.setEntries(Arrays.asList((SyndEntry)entry));
        }
        catch (CloneNotSupportedException e) {
            LOG.debug("Could not create a new feed. This exception will be ignored.", (Throwable)e);
            newFeed = null;
        }
        exchange.getIn().setBody((Object)newFeed);
        return exchange;
    }

    protected FeedPollingConsumer createEntryPollingConsumer(FeedEndpoint feedEndpoint, Processor processor, boolean throttleEntries) throws Exception {
        RssEntryPollingConsumer answer = new RssEntryPollingConsumer(this, processor, throttleEntries);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected FeedPollingConsumer createPollingConsumer(FeedEndpoint feedEndpoint, Processor processor) throws Exception {
        RssPollingConsumer answer = new RssPollingConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }
}

