/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.component.servicenow.model.ImportSetResponse;
import org.apache.camel.component.servicenow.model.ImportSetResult;
import org.apache.camel.util.ObjectHelper;

class HelsinkiServiceNowImportSetProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowImportSetProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", this::retrieveRecord);
        this.addDispatcher("create", this::createRecord);
    }

    private void retrieveRecord(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(ObjectHelper.notNull((Object)tableName, (String)"tableName")).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void createRecord(Exchange exchange) throws Exception {
        Response response;
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> requestModel = this.getRequestModel(in, tableName);
        boolean retrieve = (Boolean)in.getHeader("CamelServiceNowRetrieveTargetRecord", this.config::getRetrieveTargetRecordOnImport, Boolean.class);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        this.validateBody(in, requestModel);
        if (retrieve) {
            response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(tableName).invoke("POST", in.getMandatoryBody());
            if (ObjectHelper.isNotEmpty((String)response.getHeaderString("Content-Type"))) {
                for (ImportSetResult result : ((ImportSetResponse)response.readEntity(ImportSetResponse.class)).getResults()) {
                    String status = result.getStatus();
                    String table = result.getTable();
                    String sysId = result.getSysId();
                    if (!ObjectHelper.equalIgnoreCase((Object)"inserted", (Object)status)) continue;
                    responseModel = this.getResponseModel(in, table);
                    response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(ObjectHelper.notNull((Object)table, (String)"table")).path(ObjectHelper.notNull((Object)sysId, (String)"sys_id")).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET");
                    break;
                }
            }
        } else {
            response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("import").path(tableName).query(responseModel).invoke("POST", in.getMandatoryBody());
        }
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

