/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.Message;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsTemplate;
import org.apache.camel.support.PollingConsumerSupport;

public class SjmsPollingConsumer
extends PollingConsumerSupport {
    private SjmsTemplate template;
    private SjmsEndpoint jmsEndpoint;

    public SjmsPollingConsumer(SjmsEndpoint endpoint, SjmsTemplate template) {
        super((Endpoint)endpoint);
        this.jmsEndpoint = endpoint;
        this.template = template;
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    public Exchange receiveNoWait() {
        return this.receive(-1L);
    }

    public Exchange receive() {
        return this.receive(0L);
    }

    public Exchange receive(long timeout) {
        try {
            Message message = this.template.receive(this.jmsEndpoint.getDestinationName(), this.jmsEndpoint.getMessageSelector(), this.jmsEndpoint.isTopic(), timeout);
            if (message != null) {
                return this.getEndpoint().createExchange(message, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        return null;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

