/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.Smpp8BitSplitter;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppDefaultSplitter;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSplitter;
import org.apache.camel.component.smpp.SmppSplittingPolicy;
import org.apache.camel.component.smpp.SmppUcs2Splitter;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmppSmCommand
extends AbstractSmppCommand {
    public static final int SMPP_NEG_RESPONSE_MSG_TOO_LONG = 1;
    protected Charset ascii = StandardCharsets.US_ASCII;
    protected Charset latin1 = StandardCharsets.ISO_8859_1;
    protected Charset defaultCharset;
    private final Logger logger = LoggerFactory.getLogger(SmppSmCommand.class);

    public SmppSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
        this.defaultCharset = Charset.forName(config.getEncoding());
    }

    protected byte[][] splitBody(Message message) throws SmppException {
        byte[] shortMessage = this.getShortMessage(message);
        SmppSplitter splitter = this.createSplitter(message);
        byte[][] segments = splitter.split(shortMessage);
        if (segments.length > 1) {
            SmppSplittingPolicy policy = this.getSplittingPolicy(message);
            switch (policy) {
                case ALLOW: {
                    return segments;
                }
                case TRUNCATE: {
                    return new byte[][]{Arrays.copyOfRange(shortMessage, 0, segments[0].length)};
                }
                case REJECT: {
                    NegativeResponseException nre = new NegativeResponseException(1);
                    throw new SmppException((Throwable)nre);
                }
            }
            throw new SmppException("Unknown splitting policy: " + policy);
        }
        return segments;
    }

    private SmppSplittingPolicy getSplittingPolicy(Message message) throws SmppException {
        if (message.getHeaders().containsKey("CamelSmppSplittingPolicy")) {
            String policyName = (String)message.getHeader("CamelSmppSplittingPolicy", String.class);
            return SmppSplittingPolicy.fromString(policyName);
        }
        return this.config.getSplittingPolicy();
    }

    protected SmppSplitter createSplitter(Message message) throws SmppException {
        if (message.getHeaders().containsKey("CamelSmppSplitter")) {
            SmppSplitter splitter = (SmppSplitter)message.getHeader("CamelSmppSplitter", SmppSplitter.class);
            if (null != splitter) {
                return splitter;
            }
            throw new SmppException("Invalid splitter given. Must be instance of SmppSplitter");
        }
        Alphabet alphabet = this.determineAlphabet(message);
        String body = (String)message.getBody(String.class);
        SmppSplitter splitter = SmppUtils.is8Bit(alphabet) ? new Smpp8BitSplitter(body.length()) : (alphabet == Alphabet.ALPHA_UCS2 ? new SmppUcs2Splitter(body.length()) : new SmppDefaultSplitter(body.length()));
        return splitter;
    }

    protected final byte[] getShortMessage(Message message) {
        if (SmppSmCommand.has8bitDataCoding(message)) {
            return (byte[])message.getBody(byte[].class);
        }
        byte providedAlphabet = this.getProvidedAlphabet(message);
        Alphabet determinedAlphabet = this.determineAlphabet(message);
        Charset charset = this.determineCharset(message, providedAlphabet, determinedAlphabet.value());
        String body = (String)message.getBody(String.class);
        return body.getBytes(charset);
    }

    private static boolean has8bitDataCoding(Message message) {
        Byte dcs = (Byte)message.getHeader("CamelSmppDataCoding", Byte.class);
        if (dcs != null) {
            return SmppUtils.is8Bit(Alphabet.parseDataCoding((byte)dcs));
        }
        Byte alphabet = (Byte)message.getHeader("CamelSmppAlphabet", Byte.class);
        return alphabet != null && SmppUtils.is8Bit(Alphabet.valueOf((byte)alphabet));
    }

    private byte getProvidedAlphabet(Message message) {
        byte alphabet = this.config.getAlphabet();
        if (message.getHeaders().containsKey("CamelSmppAlphabet")) {
            alphabet = (Byte)message.getHeader("CamelSmppAlphabet", Byte.class);
        }
        return alphabet;
    }

    private Charset getCharsetForMessage(Message message) {
        if (message.getHeaders().containsKey("CamelSmppEncoding")) {
            String encoding = (String)message.getHeader("CamelSmppEncoding", String.class);
            if (Charset.isSupported(encoding)) {
                return Charset.forName(encoding);
            }
            this.logger.warn("Unsupported encoding \"{}\" requested in header.", (Object)encoding);
        }
        return null;
    }

    private Charset determineCharset(Message message, byte providedAlphabet, byte determinedAlphabet) {
        Charset result = this.getCharsetForMessage(message);
        if (result != null) {
            return result;
        }
        if (providedAlphabet == Alphabet.ALPHA_UCS2.value() || providedAlphabet == -1 && determinedAlphabet == Alphabet.ALPHA_UCS2.value()) {
            return StandardCharsets.UTF_16BE;
        }
        return this.defaultCharset;
    }

    private Alphabet determineAlphabet(Message message) {
        Alphabet alphabetObj;
        String body = (String)message.getBody(String.class);
        byte alphabet = this.getProvidedAlphabet(message);
        Charset charset = this.getCharsetForMessage(message);
        if (charset == null) {
            charset = this.defaultCharset;
        }
        if (alphabet == -1) {
            byte[] messageBytes;
            alphabetObj = Alphabet.ALPHA_UCS2;
            if (this.isLatin1Compatible(charset) && SmppUtils.isGsm0338Encodeable(messageBytes = body.getBytes(charset))) {
                alphabetObj = Alphabet.ALPHA_DEFAULT;
            }
        } else {
            alphabetObj = Alphabet.valueOf((byte)alphabet);
        }
        return alphabetObj;
    }

    private boolean isLatin1Compatible(Charset c) {
        return c.equals(this.ascii) || c.equals(this.latin1);
    }

    protected byte getRegisterDeliveryFlag(Message message) {
        if (message.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            return (Byte)message.getHeader("CamelSmppRegisteredDelivery", Byte.class);
        }
        return this.config.getRegisteredDelivery();
    }

    protected boolean getRequestsSingleDLR(Message message) {
        if (message.getHeaders().containsKey("CamelSmppSingleDLR")) {
            return (Boolean)message.getHeader("CamelSmppSingleDLR", Boolean.class);
        }
        return this.config.isSingleDLR();
    }
}

