/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmppCommand
implements SmppCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SMPPSession session;
    protected SmppConfiguration config;

    public AbstractSmppCommand(SMPPSession session, SmppConfiguration config) {
        this.session = session;
        this.config = config;
    }

    protected List<OptionalParameter> createOptionalParametersByCode(Map<Short, Object> optinalParamaters) {
        ArrayList<OptionalParameter> optParams = new ArrayList<OptionalParameter>();
        for (Map.Entry<Short, Object> entry : optinalParamaters.entrySet()) {
            OptionalParameter.Null optParam = null;
            Short key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (value == null) {
                    optParam = new OptionalParameter.Null(key.shortValue());
                } else if (value instanceof byte[]) {
                    optParam = new OptionalParameter.OctetString(key.shortValue(), (byte[])value);
                } else if (value instanceof String) {
                    optParam = new OptionalParameter.COctetString(key.shortValue(), (String)value);
                } else if (value instanceof Byte) {
                    optParam = new OptionalParameter.Byte(key.shortValue(), ((Byte)value).byteValue());
                } else if (value instanceof Integer) {
                    optParam = new OptionalParameter.Int(key.shortValue(), ((Integer)value).intValue());
                } else if (value instanceof Short) {
                    optParam = new OptionalParameter.Short(key.shortValue(), ((Short)value).shortValue());
                } else {
                    this.log.info("Couldn't determine optional parameter for value {} (type: {}). Skip this one.", value, value.getClass());
                    continue;
                }
                optParams.add((OptionalParameter)optParam);
            }
            catch (Exception e) {
                this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", (Object)key, value);
            }
        }
        return optParams;
    }

    @Deprecated
    protected List<OptionalParameter> createOptionalParametersByName(Map<String, String> optinalParamaters) {
        ArrayList<OptionalParameter> optParams = new ArrayList<OptionalParameter>();
        for (Map.Entry<String, String> entry : optinalParamaters.entrySet()) {
            OptionalParameter optParam = null;
            String value = entry.getValue();
            try {
                OptionalParameter.Tag tag = OptionalParameter.Tag.valueOf((String)entry.getKey());
                Class<? extends OptionalParameter> type = this.determineTypeClass(tag);
                HashSet<Class<? extends OptionalParameter>> ancestorClasses = new HashSet<Class<? extends OptionalParameter>>(2);
                Class<? extends OptionalParameter> superclass = type.getSuperclass();
                ancestorClasses.add(superclass);
                if (superclass != Object.class) {
                    ancestorClasses.add(superclass.getSuperclass());
                }
                if (ancestorClasses.contains(OptionalParameter.OctetString.class)) {
                    optParam = type.getConstructor(byte[].class).newInstance(new Object[]{value.getBytes()});
                } else if (ancestorClasses.contains(OptionalParameter.Byte.class)) {
                    Byte byteValue = value == null ? (byte)0 : Byte.parseByte(value);
                    optParam = type.getConstructor(Byte.TYPE).newInstance(byteValue);
                } else if (ancestorClasses.contains(OptionalParameter.Int.class)) {
                    Integer intValue = value == null ? 0 : Integer.parseInt(value);
                    optParam = type.getConstructor(Integer.TYPE).newInstance(intValue);
                } else if (ancestorClasses.contains(OptionalParameter.Short.class)) {
                    Short shortValue = value == null ? (short)0 : Short.parseShort(value);
                    optParam = type.getConstructor(Short.TYPE).newInstance(shortValue);
                }
                optParams.add(optParam);
            }
            catch (Exception e) {
                this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", (Object)entry.getKey(), (Object)value);
            }
        }
        return optParams;
    }

    protected Class<? extends OptionalParameter> determineTypeClass(OptionalParameter.Tag tag) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = tag.getClass().getDeclaredField("type");
        f.setAccessible(true);
        return (Class)f.get(tag);
    }
}

