/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Base64;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.util.IOHelper;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnection;

public final class SmppConnectionFactory
implements ConnectionFactory {
    private final SmppConfiguration config;

    private SmppConnectionFactory(SmppConfiguration config) {
        this.config = config;
    }

    public static SmppConnectionFactory getInstance(SmppConfiguration config) {
        return new SmppConnectionFactory(config);
    }

    public Connection createConnection(String host, int port) throws IOException {
        try {
            Socket socket;
            SocketFactory socketFactory;
            SocketFactory socketFactory2 = socketFactory = this.config.isUsingSSL() && this.config.getHttpProxyHost() == null ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
            if (this.config.getHttpProxyHost() != null) {
                socket = socketFactory.createSocket();
                socket.connect(new InetSocketAddress(this.config.getHttpProxyHost(), (int)this.config.getHttpProxyPort()), this.config.getEnquireLinkTimer());
                this.connectProxy(host, port, socket);
            } else {
                socket = socketFactory.createSocket();
                socket.connect(new InetSocketAddress(host, port), this.config.getEnquireLinkTimer());
            }
            if (this.config.isUsingSSL() && this.config.getHttpProxyHost() != null) {
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, host, port, true);
                sslSocket.startHandshake();
                socket = sslSocket;
            }
            return new SocketConnection(socket);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void connectProxy(String host, int port, Socket socket) throws IOException {
        try {
            String reason;
            int code;
            Map<String, String> proxyHeaders;
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            String connectString = "CONNECT " + host + ":" + port + " HTTP/1.0\r\n";
            out.write(connectString.getBytes());
            String username = this.config.getHttpProxyUsername();
            String password = this.config.getHttpProxyPassword();
            if (username != null && password != null) {
                String usernamePassword = username + ":" + password;
                Object code2 = Base64.getEncoder().encode(usernamePassword.getBytes());
                out.write("Proxy-Authorization: Basic ".getBytes());
                out.write((byte[])code2);
                out.write("\r\n".getBytes());
            }
            if ((proxyHeaders = this.config.getProxyHeaders()) != null) {
                for (Map.Entry entry : proxyHeaders.entrySet()) {
                    out.write(((String)entry.getKey() + ": " + (String)entry.getValue()).getBytes());
                    out.write("\r\n".getBytes());
                }
            }
            out.write("\r\n".getBytes());
            out.flush();
            int ch = 0;
            BufferedReader bufferedReader = IOHelper.buffered((Reader)new InputStreamReader(in));
            String response = bufferedReader.readLine();
            if (response == null) {
                throw new RuntimeCamelException("Empty response to CONNECT request to host " + host + ":" + port);
            }
            try {
                ch = response.indexOf(32);
                int bar = response.indexOf(32, ch + 1);
                code = Integer.parseInt(response.substring(ch + 1, bar));
                reason = response.substring(bar + 1);
            }
            catch (NumberFormatException e) {
                throw new RuntimeCamelException("Invalid response to CONNECT request to host " + host + ":" + port + " - cannot parse code from response string: " + response);
            }
            if (code != 200) {
                throw new RuntimeCamelException("Proxy error: " + reason);
            }
            while (!response.isEmpty()) {
                response = bufferedReader.readLine();
                if (response != null) continue;
                throw new RuntimeCamelException("Proxy error: reached end of stream");
            }
        }
        catch (RuntimeException re) {
            SmppConnectionFactory.closeSocket(socket);
            throw re;
        }
        catch (Exception e) {
            SmppConnectionFactory.closeSocket(socket);
            throw new RuntimeCamelException("SmppConnectionFactory: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void closeSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

