/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snakeyaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class SnakeYAMLDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private ThreadLocal<WeakReference<Yaml>> yamlCache;
    private BaseConstructor constructor;
    private Representer representer;
    private DumperOptions dumperOptions;
    private Resolver resolver;
    private ClassLoader classLoader;
    private Class<?> unmarshalType;
    private List<TypeDescription> typeDescriptions;
    private Map<Class<?>, Tag> classTags;
    private boolean useApplicationContextClassLoader;
    private boolean prettyFlow;

    public SnakeYAMLDataFormat() {
        this(Object.class);
    }

    public SnakeYAMLDataFormat(Class<?> type) {
        this.unmarshalType = type;
        this.yamlCache = new ThreadLocal();
        this.useApplicationContextClassLoader = true;
        this.prettyFlow = false;
    }

    public String getDataFormatName() {
        return "yaml-snakeyaml";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange));){
            this.getYaml(exchange.getContext()).dump(graph, (Writer)osw);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        try (InputStreamReader isr = new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange));){
            Object object = this.getYaml(exchange.getContext()).loadAs((Reader)isr, this.unmarshalType);
            return object;
        }
    }

    protected Yaml getYaml(CamelContext context) {
        Yaml yaml = null;
        WeakReference<Yaml> ref = this.yamlCache.get();
        if (ref != null) {
            yaml = (Yaml)ref.get();
        }
        if (yaml == null) {
            BaseConstructor yamlConstructor = this.constructor;
            Representer yamlRepresenter = this.representer;
            DumperOptions yamlDumperOptions = this.dumperOptions;
            Resolver yamlResolver = this.resolver;
            ClassLoader yamlClassLoader = this.classLoader;
            if (yamlClassLoader == null && this.useApplicationContextClassLoader) {
                yamlClassLoader = context.getApplicationContextClassLoader();
            }
            if (yamlConstructor == null) {
                Object object = yamlConstructor = yamlClassLoader == null ? new Constructor() : new CustomClassLoaderConstructor(yamlClassLoader);
                if (this.typeDescriptions != null) {
                    for (TypeDescription typeDescription : this.typeDescriptions) {
                        ((Constructor)yamlConstructor).addTypeDescription(typeDescription);
                    }
                }
            }
            if (yamlRepresenter == null) {
                yamlRepresenter = new Representer();
                if (this.classTags != null) {
                    for (Map.Entry entry : this.classTags.entrySet()) {
                        yamlRepresenter.addClassTag((Class)entry.getKey(), (Tag)entry.getValue());
                    }
                }
            }
            if (yamlDumperOptions == null) {
                yamlDumperOptions = new DumperOptions();
                yamlDumperOptions.setPrettyFlow(this.prettyFlow);
            }
            if (yamlResolver == null) {
                yamlResolver = new Resolver();
            }
            yaml = new Yaml(yamlConstructor, yamlRepresenter, yamlDumperOptions, yamlResolver);
            this.yamlCache.set(new WeakReference<Yaml>(yaml));
        }
        return yaml;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public BaseConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(BaseConstructor constructor) {
        this.constructor = constructor;
    }

    public Representer getRepresenter() {
        return this.representer;
    }

    public void setRepresenter(Representer representer) {
        this.representer = representer;
    }

    public DumperOptions getDumperOptions() {
        return this.dumperOptions;
    }

    public void setDumperOptions(DumperOptions dumperOptions) {
        this.dumperOptions = dumperOptions;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public List<TypeDescription> getTypeDescriptions() {
        return this.typeDescriptions;
    }

    public void setTypeDescriptions(List<TypeDescription> typeDescriptions) {
        this.typeDescriptions = typeDescriptions;
    }

    public void addTypeDescriptions(TypeDescription ... typeDescriptions) {
        if (this.typeDescriptions == null) {
            this.typeDescriptions = new LinkedList<TypeDescription>();
        }
        for (TypeDescription typeDescription : typeDescriptions) {
            this.typeDescriptions.add(typeDescription);
        }
    }

    public void addTypeDescription(Class<?> type, Tag tag) {
        if (this.typeDescriptions == null) {
            this.typeDescriptions = new LinkedList<TypeDescription>();
        }
        this.typeDescriptions.add(new TypeDescription(type, tag));
    }

    public Map<Class<?>, Tag> getClassTags() {
        return this.classTags;
    }

    public void setClassTags(Map<Class<?>, Tag> classTags) {
        this.classTags = classTags;
    }

    public void addClassTags(Class<?> type, Tag tag) {
        if (this.classTags == null) {
            this.classTags = new LinkedHashMap();
        }
        this.classTags.put(type, tag);
    }

    public boolean isUseApplicationContextClassLoader() {
        return this.useApplicationContextClassLoader;
    }

    public void setUseApplicationContextClassLoader(boolean useApplicationContextClassLoader) {
        this.useApplicationContextClassLoader = useApplicationContextClassLoader;
    }

    public boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public void setPrettyFlow(boolean prettyFlow) {
        this.prettyFlow = prettyFlow;
    }

    public void addTag(Class<?> type, Tag tag) {
        this.addClassTags(type, tag);
        this.addTypeDescription(type, tag);
    }
}

