/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springldap;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.springldap.LdapOperation;
import org.apache.camel.component.springldap.SpringLdapProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.springframework.ldap.core.LdapTemplate;

public class SpringLdapEndpoint
extends DefaultEndpoint {
    private static final String OBJECT_SCOPE_NAME = "object";
    private static final String ONELEVEL_SCOPE_NAME = "onelevel";
    private static final String SUBTREE_SCOPE_NAME = "subtree";
    private static Map<String, LdapOperation> operationMap;
    private static Map<String, Integer> scopeMap;
    private LdapTemplate ldapTemplate;
    private LdapOperation operation;
    private int scope = 2;
    private String templateName;

    public SpringLdapEndpoint(String templateName, LdapTemplate ldapTemplate) {
        this.templateName = templateName;
        this.ldapTemplate = ldapTemplate;
        if (null == operationMap) {
            SpringLdapEndpoint.initializeOperationMap();
        }
        if (null == scopeMap) {
            SpringLdapEndpoint.initializeScopeMap();
        }
    }

    private static void initializeScopeMap() {
        scopeMap = new HashMap<String, Integer>();
        scopeMap.put(OBJECT_SCOPE_NAME, 0);
        scopeMap.put(ONELEVEL_SCOPE_NAME, 1);
        scopeMap.put(SUBTREE_SCOPE_NAME, 2);
    }

    private static void initializeOperationMap() {
        operationMap = new HashMap<String, LdapOperation>();
        operationMap.put(LdapOperation.SEARCH.name(), LdapOperation.SEARCH);
        operationMap.put(LdapOperation.BIND.name(), LdapOperation.BIND);
        operationMap.put(LdapOperation.UNBIND.name(), LdapOperation.UNBIND);
    }

    public Producer createProducer() throws Exception {
        return new SpringLdapProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("spring-ldap endpoint supports producer enrpoint only.");
    }

    public boolean isSingleton() {
        return false;
    }

    int getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        for (Map.Entry<String, Integer> allowedScope : scopeMap.entrySet()) {
            if (!allowedScope.getKey().equals(scope)) continue;
            this.scope = allowedScope.getValue();
            return;
        }
        throw new UnsupportedOperationException("Search scope '" + scope + "' is not supported. The supported scopes are 'object', 'onelevel', and 'subtree'.");
    }

    LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    public String createEndpointUri() {
        return "spring-ldap://" + this.templateName + "?operation=" + this.operation.name() + "&scope=" + this.getScopeName();
    }

    private String getScopeName() {
        for (String key : scopeMap.keySet()) {
            if (this.scope != scopeMap.get(key)) continue;
            return key;
        }
        throw new UnsupportedOperationException("Search scope '" + this.scope + "' is not supported. The supported scopes are 'object', 'onelevel', and 'subtree'.");
    }

    LdapOperation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        for (Map.Entry<String, LdapOperation> allowedOperation : operationMap.entrySet()) {
            if (!allowedOperation.getKey().equalsIgnoreCase(operation)) continue;
            this.operation = allowedOperation.getValue();
            return;
        }
        throw new UnsupportedOperationException("LDAP operation '" + operation + "' is not supported. The supported operations are 'search', 'bind', and 'unbind'.");
    }
}

