/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.SpringWebserviceMessage;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;

public class SpringWebserviceConsumer
extends DefaultConsumer
implements MessageEndpoint {
    private SpringWebserviceEndpoint endpoint;
    private SpringWebserviceConfiguration configuration;

    public SpringWebserviceConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (SpringWebserviceEndpoint)endpoint;
        this.configuration = this.endpoint.getConfiguration();
    }

    public void invoke(MessageContext messageContext) throws Exception {
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOptionalOut);
        this.populateExchangeFromMessageContext(messageContext, exchange);
        this.populateExchangeWithBreadcrumbFromMessageContext(messageContext, exchange);
        this.getProcessor().process(exchange);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        if (exchange.getPattern().isOutCapable()) {
            Message responseMessage;
            Message message = responseMessage = exchange.hasOut() ? (Message)exchange.getOut(Message.class) : (Message)exchange.getIn(Message.class);
            if (responseMessage != null) {
                Source responseBody = (Source)responseMessage.getBody(Source.class);
                WebServiceMessage response = messageContext.getResponse();
                this.configuration.getMessageFilter().filterConsumer(exchange, response);
                XmlConverter xmlConverter = this.configuration.getXmlConverter();
                xmlConverter.toResult(responseBody, response.getPayloadResult());
            }
        }
    }

    private void populateExchangeWithBreadcrumbFromMessageContext(MessageContext messageContext, Exchange exchange) {
        String[] breadcrumbIdHeaderValues;
        MimeHeaders mimeHeaders;
        SaajSoapMessage saajSoap = (SaajSoapMessage)messageContext.getRequest();
        SOAPMessage soapMessageRequest = null;
        if (saajSoap != null && (soapMessageRequest = saajSoap.getSaajMessage()) != null && (mimeHeaders = soapMessageRequest.getMimeHeaders()) != null && (breadcrumbIdHeaderValues = mimeHeaders.getHeader("breadcrumbId")) != null && breadcrumbIdHeaderValues.length >= 1) {
            exchange.getIn().setHeader("breadcrumbId", (Object)breadcrumbIdHeaderValues[0]);
        }
    }

    private void populateExchangeFromMessageContext(MessageContext messageContext, Exchange exchange) {
        this.populateExchangeWithPropertiesFromMessageContext(messageContext, exchange);
        WebServiceMessage request = messageContext.getRequest();
        SpringWebserviceMessage inMessage = new SpringWebserviceMessage(request);
        this.extractSourceFromSoapHeader(inMessage.getHeaders(), request);
        this.extractAttachmentsFromRequest(request, inMessage);
        exchange.setIn((Message)inMessage);
    }

    private void populateExchangeWithPropertiesFromMessageContext(MessageContext messageContext, Exchange exchange) {
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                exchange.setProperty(propertyName, messageContext.getProperty(propertyName));
            }
        }
    }

    private void extractSourceFromSoapHeader(Map<String, Object> headers, WebServiceMessage request) {
        SoapMessage soapMessage;
        SoapHeader soapHeader;
        if (request instanceof SoapMessage && (soapHeader = (soapMessage = (SoapMessage)request).getSoapHeader()) != null) {
            headers.put("CamelSpringWebserviceSoapHeader", soapHeader.getSource());
            Iterator attIter = soapHeader.getAllAttributes();
            while (attIter.hasNext()) {
                QName name = (QName)attIter.next();
                headers.put(name.getLocalPart(), soapHeader.getAttributeValue(name));
            }
            Iterator elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                SoapHeaderElement element = (SoapHeaderElement)elementIter.next();
                QName name = element.getName();
                headers.put(name.getLocalPart(), element);
            }
        }
    }

    private void extractAttachmentsFromRequest(WebServiceMessage request, SpringWebserviceMessage inMessage) {
        if (request instanceof MimeMessage) {
            Iterator attachmentsIterator = ((MimeMessage)request).getAttachments();
            while (attachmentsIterator.hasNext()) {
                Attachment attachment = (Attachment)attachmentsIterator.next();
                inMessage.addAttachment(attachment.getContentId(), attachment.getDataHandler());
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().removeConsumer(this.configuration.getEndpointMappingKey());
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().addConsumer(this.configuration.getEndpointMappingKey(), this);
        }
        super.doStart();
    }
}

