/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.addressing.client.ActionCallback;
import org.springframework.ws.soap.client.core.SoapActionCallback;

public class SpringWebserviceProducer
extends DefaultProducer {
    private static final SourceExtractor<Object> SOURCE_EXTRACTOR = new NoopSourceExtractor();
    private SpringWebserviceEndpoint endpoint;

    public SpringWebserviceProducer(Endpoint endpoint) {
        super(endpoint);
        this.endpoint = (SpringWebserviceEndpoint)endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Source sourcePayload = (Source)exchange.getIn().getMandatoryBody(Source.class);
        String endpointUri = (String)exchange.getIn().getHeader("CamelSpringWebserviceEndpointUri", String.class);
        String soapAction = (String)exchange.getIn().getHeader("CamelSpringWebserviceSoapAction", String.class);
        URI wsAddressingAction = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingAction", URI.class);
        DefaultWebserviceMessageCallback callback = new DefaultWebserviceMessageCallback(soapAction, wsAddressingAction);
        Object body = null;
        body = endpointUri != null ? this.endpoint.getConfiguration().getWebServiceTemplate().sendSourceAndReceive(endpointUri, sourcePayload, (WebServiceMessageCallback)callback, SOURCE_EXTRACTOR) : this.endpoint.getConfiguration().getWebServiceTemplate().sendSourceAndReceive(sourcePayload, (WebServiceMessageCallback)callback, SOURCE_EXTRACTOR);
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        }
    }

    private static class NoopSourceExtractor
    implements SourceExtractor<Object> {
        private NoopSourceExtractor() {
        }

        public Object extractData(Source source) throws IOException, TransformerException {
            return source;
        }
    }

    protected class DefaultWebserviceMessageCallback
    implements WebServiceMessageCallback {
        private String soapActionHeader;
        private URI wsAddressingActionHeader;

        public DefaultWebserviceMessageCallback(String soapAction, URI wsAddressingAction) {
            this.soapActionHeader = soapAction;
            this.wsAddressingActionHeader = wsAddressingAction;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            URI wsAddressingAction;
            String soapAction;
            String string = soapAction = this.soapActionHeader != null ? this.soapActionHeader : SpringWebserviceProducer.this.endpoint.getConfiguration().getSoapAction();
            if (soapAction != null) {
                new SoapActionCallback(soapAction).doWithMessage(message);
            }
            URI uRI = wsAddressingAction = this.wsAddressingActionHeader != null ? this.wsAddressingActionHeader : SpringWebserviceProducer.this.endpoint.getConfiguration().getWsAddressingAction();
            if (wsAddressingAction != null) {
                new ActionCallback(wsAddressingAction).doWithMessage(message);
            }
        }
    }
}

