/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.net.URI;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.StringHelper;
import org.apache.sshd.common.keyprovider.KeyPairProvider;

@UriParams
public class SshConfiguration
implements Cloneable {
    public static final int DEFAULT_SSH_PORT = 22;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath(defaultValue="22")
    private int port = 22;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="consumer")
    private String pollCommand;
    @UriParam(label="security")
    private KeyPairProvider keyPairProvider;
    @UriParam(label="security")
    private String keyType;
    @UriParam(label="security")
    private String certResource;
    @UriParam(label="security", secret=true)
    private String certResourcePassword;
    @UriParam(defaultValue="30000")
    private long timeout = 30000L;
    @UriParam
    private String knownHostsResource;
    @UriParam(defaultValue="false")
    private boolean failOnUnknownHost;
    @UriParam(label="advanced", defaultValue="exec")
    private String channelType = "exec";
    @UriParam(label="advanced")
    private String shellPrompt;
    @UriParam(label="advanced", defaultValue="100")
    private long sleepForShellPrompt;

    public SshConfiguration() {
    }

    public SshConfiguration(URI uri) {
        this.configure(uri);
    }

    public void configure(URI uri) {
        String username = uri.getUserInfo();
        String pw = null;
        if (username != null && username.contains(":")) {
            pw = StringHelper.after((String)username, (String)":");
            username = StringHelper.before((String)username, (String)":");
        }
        if (username != null) {
            this.setUsername(username);
        }
        if (pw != null) {
            this.setPassword(pw);
        }
        if (this.getHost() == null && uri.getHost() != null) {
            this.setHost(uri.getHost());
        }
        int uriPort = uri.getPort();
        if (this.getPort() == 22 && uriPort != -1) {
            this.setPort(uriPort);
        }
    }

    public SshConfiguration copy() {
        try {
            return (SshConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPollCommand() {
        return this.pollCommand;
    }

    public void setPollCommand(String pollCommand) {
        this.pollCommand = pollCommand;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getCertResource() {
        return this.certResource;
    }

    public void setCertResource(String certResource) {
        this.certResource = certResource;
    }

    public String getCertResourcePassword() {
        return this.certResourcePassword;
    }

    public void setCertResourcePassword(String certResourcePassword) {
        this.certResourcePassword = certResourcePassword;
    }

    public String getKnownHostsResource() {
        return this.knownHostsResource;
    }

    public void setKnownHostsResource(String knownHostsResource) {
        this.knownHostsResource = knownHostsResource;
    }

    public boolean isFailOnUnknownHost() {
        return this.failOnUnknownHost;
    }

    public void setFailOnUnknownHost(boolean failOnUnknownHost) {
        this.failOnUnknownHost = failOnUnknownHost;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getShellPrompt() {
        return this.shellPrompt;
    }

    public void setShellPrompt(String shellPrompt) {
        this.shellPrompt = shellPrompt;
    }

    public long getSleepForShellPrompt() {
        return this.sleepForShellPrompt;
    }

    public void setSleepForShellPrompt(long sleepForShellPrompt) {
        this.sleepForShellPrompt = sleepForShellPrompt;
    }
}

