/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stomp.StompComponent;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.component.stomp.StompConsumer;
import org.apache.camel.component.stomp.StompProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.CallbackConnection;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.client.Promise;
import org.fusesource.stomp.client.Stomp;
import org.fusesource.stomp.codec.StompFrame;

public class StompEndpoint
extends DefaultEndpoint {
    private CallbackConnection connection;
    private StompConfiguration configuration;
    private String destination;
    private Stomp stomp;
    private final List<StompConsumer> consumers = new CopyOnWriteArrayList<StompConsumer>();

    public StompEndpoint(String uri, StompComponent component, StompConfiguration configuration, String destination) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.destination = destination;
    }

    public Producer createProducer() throws Exception {
        return new StompProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new StompConsumer((Endpoint)this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        Promise promise = new Promise();
        this.stomp = new Stomp(this.configuration.getBrokerURL());
        this.stomp.setLogin(this.configuration.getLogin());
        this.stomp.setPasscode(this.configuration.getPasscode());
        this.stomp.connectCallback((Callback)promise);
        this.connection = (CallbackConnection)promise.await();
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompEndpoint.this.connection.receive((Callback)new Callback<StompFrame>(){

                    public void onFailure(Throwable value) {
                        if (StompEndpoint.this.started.get()) {
                            StompEndpoint.this.connection.close(null);
                        }
                    }

                    public void onSuccess(StompFrame value) {
                        if (!StompEndpoint.this.consumers.isEmpty()) {
                            Exchange exchange = StompEndpoint.this.createExchange();
                            exchange.getIn().setBody((Object)value.content());
                            for (StompConsumer consumer : StompEndpoint.this.consumers) {
                                consumer.processExchange(exchange);
                            }
                        }
                    }
                });
                StompEndpoint.this.connection.resume();
            }
        });
    }

    protected void doStop() throws Exception {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.DISCONNECT);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.connection.close(null);
    }

    protected void send(Message message) {
        final StompFrame frame = new StompFrame(Constants.SEND);
        frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)this.destination));
        frame.content((Buffer)UTF8Buffer.utf8((String)message.getBody().toString()));
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompEndpoint.this.connection.send(frame, null);
            }
        });
    }

    void addConsumer(final StompConsumer consumer) {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.SUBSCRIBE);
                frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)StompEndpoint.this.destination));
                frame.addHeader(Constants.ID, consumer.id);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.consumers.add(consumer);
    }

    void removeConsumer(final StompConsumer consumer) {
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                StompFrame frame = new StompFrame(Constants.UNSUBSCRIBE);
                frame.addHeader(Constants.DESTINATION, StompFrame.encodeHeader((String)StompEndpoint.this.destination));
                frame.addHeader(Constants.ID, consumer.id);
                StompEndpoint.this.connection.send(frame, null);
            }
        });
        this.consumers.remove((Object)consumer);
    }

    AsciiBuffer getNextId() {
        return this.connection.nextId();
    }
}

