/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Service;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public abstract class ChildServiceSupport
extends ServiceSupport {
    protected volatile List<Service> childServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 3) {
                this.log.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 2) {
                this.log.trace("Service: {} already starting", (Object)this);
                return;
            }
            this.status = 2;
            this.log.trace("Starting service: {}", (Object)this);
            try {
                ServiceHelper.startService(this.childServices);
                this.doStart();
                this.status = 3;
                this.log.trace("Service: {} started", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while starting service: " + (Object)((Object)this), (Throwable)e);
                ServiceHelper.stopService(this.childServices);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 7 || this.status == 8 || this.status == 9) {
                this.log.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 6) {
                this.log.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = 6;
            this.log.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                ServiceHelper.stopService(this.childServices);
                this.status = 7;
                this.log.trace("Service: {} stopped service", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while stopping service: " + (Object)((Object)this), (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 9) {
                this.log.trace("Service: {} already shut down", (Object)this);
                return;
            }
            if (this.status == 8) {
                this.log.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = 9;
            this.log.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                ServiceHelper.stopAndShutdownServices(this.childServices);
                this.log.trace("Service: {} shut down", (Object)this);
                this.status = 9;
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error shutting down service: " + (Object)((Object)this), (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        if (childService instanceof Service) {
            if (this.childServices == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.childServices == null) {
                        this.childServices = new CopyOnWriteArrayList<Service>();
                    }
                }
            }
            this.childServices.add((Service)childService);
        }
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }
}

