/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyPlaceholdersHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.function.Suppliers;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW[({].*&&.*[)}]");
    private final List<Supplier<ComponentExtension>> extensions = new ArrayList<Supplier<ComponentExtension>>();
    private CamelContext camelContext;
    @Metadata(label="advanced", defaultValue="true", description="Whether the component should resolve property placeholders on itself when starting. Only properties which are of String type can use property placeholders.")
    private boolean resolvePropertyPlaceholders = true;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        return UnsafeUriCharactersEncoder.encode((String)uri);
    }

    public Endpoint createEndpoint(String uri) throws Exception {
        Map parameters;
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String encodedUri = this.preProcessUri(uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        URISupport.resolveRawParameterValues((Map)parameters);
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        endpoint.configureProperties(parameters);
        if (this.useIntrospectionOnEndpoint()) {
            this.setProperties(endpoint, parameters);
        }
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public boolean useRawUri() {
        return false;
    }

    public void setResolvePropertyPlaceholders(boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public boolean isResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map<String, Object> param = parameters;
        if (optionPrefix != null) {
            param = IntrospectionSupport.extractProperties(parameters, optionPrefix);
        }
        if (param.size() > 0) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + param + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Matcher m;
        if (uri.contains("&&") && !(m = RAW_PATTERN.matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        if (this.isResolvePropertyPlaceholders()) {
            PropertiesComponent existing = this.camelContext.getPropertiesComponent(false);
            if (existing != null) {
                this.log.debug("Resolving property placeholders on component: {}", (Object)this);
                PropertyPlaceholdersHelper.resolvePropertyPlaceholders(this.camelContext, (Object)this);
            } else {
                this.log.debug("Cannot resolve property placeholders on component: {} as PropertiesComponent is not in use", (Object)this);
            }
        }
    }

    protected void doStop() throws Exception {
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        this.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected void setProperties(CamelContext camelContext, Object bean, Map<String, Object> parameters) throws Exception {
        EndpointHelper.setReferenceProperties(camelContext, bean, parameters);
        EndpointHelper.setProperties(camelContext, bean, parameters);
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value != null) {
            return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
        }
        value = defaultValue;
        if (value == null) {
            return null;
        }
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        if (EndpointHelper.isReferenceParameter(value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
        }
        return (T)this.getCamelContext().getTypeConverter().convertTo(type, (Object)value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), value, elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    protected void registerExtension(ComponentExtension extension) {
        this.extensions.add(() -> extension);
    }

    protected void registerExtension(Supplier<ComponentExtension> supplier) {
        this.extensions.add(Suppliers.memorize(supplier));
    }

    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        return this.extensions.stream().map(Supplier::get).map(Object::getClass).collect(Collectors.toList());
    }

    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        return this.extensions.stream().map(Supplier::get).filter(extensionType::isInstance).findFirst().map(extensionType::cast).map(e -> (ComponentExtension)Component.trySetComponent((Object)e, (Component)this)).map(e -> (ComponentExtension)CamelContextAware.trySetCamelContext((Object)e, (CamelContext)this.getCamelContext()));
    }
}

