/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.activation.DataHandler;
import org.apache.camel.Attachment;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.support.AttachmentMap;
import org.apache.camel.support.DefaultAttachment;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultMessage
extends MessageSupport {
    private boolean fault;
    private Map<String, Object> headers;
    private Map<String, DataHandler> attachments;
    private Map<String, Attachment> attachmentObjects;

    public DefaultMessage(Exchange exchange) {
        this.setExchange(exchange);
        this.setCamelContext(exchange != null ? exchange.getContext() : null);
    }

    public DefaultMessage(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    public boolean isFault() {
        return this.fault;
    }

    public void setFault(boolean fault) {
        this.fault = fault;
    }

    public Object getHeader(String name) {
        if (this.hasHeaders()) {
            return this.getHeaders().get(name);
        }
        return null;
    }

    public Object getHeader(String name, Object defaultValue) {
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValue;
    }

    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull(defaultValueSupplier, (String)"defaultValueSupplier");
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValueSupplier.get();
    }

    public <T> T getHeader(String name, Class<T> type) {
        Object value = this.getHeader(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        Object value = this.getHeader(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        ObjectHelper.notNull(defaultValueSupplier, (String)"defaultValueSupplier");
        Object value = this.getHeader(name, defaultValueSupplier);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(name, value);
    }

    public Object removeHeader(String name) {
        if (!this.hasHeaders()) {
            return null;
        }
        return this.headers.remove(name);
    }

    public boolean removeHeaders(String pattern) {
        return this.removeHeaders(pattern, null);
    }

    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        if (!this.hasHeaders()) {
            return false;
        }
        boolean matches = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            this.headers.remove(key);
        }
        return matches;
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        this.headers = this.getCamelContext().getHeadersMapFactory().isInstanceOf(headers) ? headers : this.getCamelContext().getHeadersMapFactory().newMap(headers);
    }

    public boolean hasHeaders() {
        if (!this.hasPopulatedHeaders()) {
            this.getHeaders();
        }
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public DefaultMessage newInstance() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        return new DefaultMessage(this.getCamelContext());
    }

    protected Map<String, Object> createHeaders() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        Map map = this.getCamelContext().getHeadersMapFactory().newMap();
        this.populateInitialHeaders(map);
        return map;
    }

    protected Map<String, Attachment> createAttachments() {
        LinkedHashMap<String, Attachment> map = new LinkedHashMap<String, Attachment>();
        this.populateInitialAttachments(map);
        return map;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
    }

    protected void populateInitialAttachments(Map<String, Attachment> map) {
    }

    protected Boolean isTransactedRedelivered() {
        return null;
    }

    public void addAttachment(String id, DataHandler content) {
        this.addAttachmentObject(id, new DefaultAttachment(content));
    }

    public void addAttachmentObject(String id, Attachment content) {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        this.attachmentObjects.put(id, content);
    }

    public DataHandler getAttachment(String id) {
        Attachment att = this.getAttachmentObject(id);
        if (att == null) {
            return null;
        }
        return att.getDataHandler();
    }

    public Attachment getAttachmentObject(String id) {
        return this.getAttachmentObjects().get(id);
    }

    public Set<String> getAttachmentNames() {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        return this.attachmentObjects.keySet();
    }

    public void removeAttachment(String id) {
        if (this.attachmentObjects != null && this.attachmentObjects.containsKey(id)) {
            this.attachmentObjects.remove(id);
        }
    }

    public Map<String, DataHandler> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new AttachmentMap(this.getAttachmentObjects());
        }
        return this.attachments;
    }

    public Map<String, Attachment> getAttachmentObjects() {
        if (this.attachmentObjects == null) {
            this.attachmentObjects = this.createAttachments();
        }
        return this.attachmentObjects;
    }

    public void setAttachments(Map<String, DataHandler> attachments) {
        if (attachments == null) {
            this.attachmentObjects = null;
        } else if (attachments instanceof AttachmentMap) {
            this.attachmentObjects = ((AttachmentMap)attachments).getOriginalMap();
        } else {
            this.attachmentObjects = new LinkedHashMap<String, Attachment>();
            for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                this.attachmentObjects.put(entry.getKey(), new DefaultAttachment(entry.getValue()));
            }
        }
        this.attachments = null;
    }

    public void setAttachmentObjects(Map<String, Attachment> attachments) {
        this.attachmentObjects = attachments;
        this.attachments = null;
    }

    public boolean hasAttachments() {
        return this.attachmentObjects != null && this.attachmentObjects.size() > 0;
    }

    protected boolean hasPopulatedHeaders() {
        return this.headers != null;
    }
}

