/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.SimpleRegistry;

public class DefaultRegistry
implements Registry,
CamelContextAware {
    protected CamelContext camelContext;
    protected List<BeanRepository> repositories;
    protected Registry fallbackRegistry = new SimpleRegistry();

    public DefaultRegistry() {
    }

    public DefaultRegistry(BeanRepository ... repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(Arrays.asList(repositories));
        }
    }

    public DefaultRegistry(Collection<BeanRepository> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(repositories);
        }
    }

    public Registry getFallbackRegistry() {
        return this.fallbackRegistry;
    }

    public void setFallbackRegistry(Registry fallbackRegistry) {
        this.fallbackRegistry = fallbackRegistry;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<BeanRepository> getRepositories() {
        if (this.repositories == null) {
            return null;
        }
        return Collections.unmodifiableList(this.repositories);
    }

    public void bind(String id, Class<?> type, Object bean) throws RuntimeCamelException {
        this.fallbackRegistry.bind(id, type, bean);
    }

    public Object lookupByName(String name) {
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Object answer = r.lookupByName(name);
                if (answer == null) continue;
                return this.unwrap(answer);
            }
        }
        return this.fallbackRegistry.lookupByName(name);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Object answer = r.lookupByNameAndType(name, type);
                if (answer == null) continue;
                return (T)this.unwrap(answer);
            }
        }
        return (T)this.fallbackRegistry.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Map answer = r.findByTypeWithName(type);
                if (answer == null) continue;
                return answer;
            }
        }
        return this.fallbackRegistry.findByTypeWithName(type);
    }

    public <T> Set<T> findByType(Class<T> type) {
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                Set answer = r.findByType(type);
                if (answer == null) continue;
                return answer;
            }
        }
        return this.fallbackRegistry.findByType(type);
    }
}

