/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.ObjectHelper;

public final class PropertyBindingSupport {
    private PropertyBindingSupport() {
    }

    public static Builder build() {
        return new Builder();
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target) {
        return PropertyBindingSupport.autowireSingletonPropertiesFromRegistry(camelContext, target, false, false, null);
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) {
        try {
            if (target != null) {
                HashSet<Object> parents = new HashSet<Object>();
                return PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, target, parents, bindNullOnly, deepNesting, callback);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, e);
        }
        return false;
    }

    private static boolean doAutowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, Set<Object> parents, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) throws Exception {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        IntrospectionSupport.getProperties(target, properties, null);
        boolean hit = false;
        for (Map.Entry entry : properties.entrySet()) {
            Set lookup;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Class type = PropertyBindingSupport.getGetterType(target, key);
            boolean skip = parents.contains(value) || value instanceof CamelContext;
            if (skip || !PropertyBindingSupport.isComplexUserType(type)) continue;
            if ((!bindNullOnly || value == null) && (lookup = camelContext.getRegistry().findByType(type)).size() == 1 && (value = lookup.iterator().next()) != null && (hit |= IntrospectionSupport.setProperty(camelContext, target, key, value)) && callback != null) {
                callback.onAutowire(target, key, type, value);
            }
            if (value == null && deepNesting) {
                Object instance;
                Class<?> parameterType;
                Method method = PropertyBindingSupport.findBestSetterMethod(target.getClass(), key, true);
                if (method == null || (parameterType = method.getParameterTypes()[0]) == null || !org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType) || (instance = camelContext.getInjector().newInstance(parameterType)) == null) continue;
                ObjectHelper.invokeMethod(method, target, instance);
                target = instance;
                parents.add(target);
                value = instance;
                hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
                continue;
            }
            if (value == null) continue;
            parents.add(target);
            hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
        }
        return hit;
    }

    public static boolean bindProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        return PropertyBindingSupport.bindProperties(camelContext, target, properties, true, true, true, true, true);
    }

    public static boolean bindProperties(CamelContext camelContext, Object target, Map<String, Object> properties, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean reference, boolean placeholder) {
        org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        PropertyBindingSupport.setReferenceProperties(camelContext, target, properties);
        Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!PropertyBindingSupport.bindProperty(camelContext, target, entry.getKey(), entry.getValue(), nesting, deepNesting, fluentBuilder, reference, placeholder)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean bindProperty(CamelContext camelContext, Object target, String name, Object value) {
        try {
            if (target != null && name != null) {
                return PropertyBindingSupport.setProperty(camelContext, target, name, value, true, true, true, true, true);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, e);
        }
        return false;
    }

    private static boolean bindProperty(CamelContext camelContext, Object target, String name, Object value, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean reference, boolean placeholder) {
        try {
            if (target != null && name != null) {
                return PropertyBindingSupport.setProperty(camelContext, target, name, value, nesting, deepNesting, fluentBuilder, reference, placeholder);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, e);
        }
        return false;
    }

    public static void bindMandatoryProperty(CamelContext camelContext, Object target, String name, Object value) {
        try {
            boolean bound;
            if (target != null && name != null && !(bound = PropertyBindingSupport.setProperty(camelContext, target, name, value, true, true, true, true, true))) {
                throw new PropertyBindingException(target, name);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, e);
        }
    }

    private static boolean setProperty(CamelContext context, Object target, String name, Object value, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean reference, boolean placeholder) throws Exception {
        String refName = null;
        if (placeholder) {
            name = context.resolvePropertyPlaceholders(name);
            if (value instanceof String) {
                value = context.resolvePropertyPlaceholders(value.toString());
            }
        }
        if (nesting && name.indexOf(46) > 0) {
            String[] parts = name.split("\\.");
            Object newTarget = target;
            Class<?> newClass = target.getClass();
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                Object prop = PropertyBindingSupport.getOrElseProperty(newTarget, part, null);
                if (prop == null) {
                    Object instance;
                    Class<?> parameterType;
                    if (!deepNesting) break;
                    Method method = PropertyBindingSupport.findBestSetterMethod(newClass, part, fluentBuilder);
                    if (method == null || (parameterType = method.getParameterTypes()[0]) == null || !org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType) || (instance = context.getInjector().newInstance(parameterType)) == null) continue;
                    ObjectHelper.invokeMethod(method, newTarget, instance);
                    newTarget = instance;
                    newClass = newTarget.getClass();
                    continue;
                }
                newTarget = prop;
                newClass = newTarget.getClass();
            }
            if (newTarget != target) {
                target = newTarget;
                name = parts[parts.length - 1];
            }
        }
        if (reference && value instanceof String) {
            Set types;
            Class type;
            if (value.toString().startsWith("#class:")) {
                String className = value.toString().substring(6);
                type = context.getClassResolver().resolveMandatoryClass(className);
                if (type != null) {
                    value = context.getInjector().newInstance(type);
                }
            } else if (value.toString().startsWith("#type:")) {
                String typeName = value.toString().substring(6);
                type = context.getClassResolver().resolveMandatoryClass(typeName);
                if (type != null && (types = context.getRegistry().findByType(type)).size() == 1) {
                    value = types.iterator().next();
                }
            } else if (value.toString().equals("#autowired")) {
                Class<?> parameterType;
                Method method = PropertyBindingSupport.findBestSetterMethod(target.getClass(), name, fluentBuilder);
                if (method != null && (parameterType = method.getParameterTypes()[0]) != null && (types = context.getRegistry().findByType(parameterType)).size() == 1) {
                    value = types.iterator().next();
                }
            } else if (value.toString().startsWith("#bean:")) {
                refName = "#" + ((String)value).substring(6);
                value = null;
            }
        }
        return IntrospectionSupport.setProperty(context, context.getTypeConverter(), target, name, value, refName, fluentBuilder);
    }

    private static Object getOrElseProperty(Object target, String property, Object defaultValue) {
        Object answer;
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        if ((answer = IntrospectionSupport.getOrElseProperty(target, key, defaultValue)) instanceof Map && lookupKey != null) {
            Map map = (Map)answer;
            answer = map.getOrDefault(lookupKey, defaultValue);
        } else if (answer instanceof List) {
            List list = (List)answer;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(lookupKey)) {
                int idx = Integer.valueOf(lookupKey);
                answer = list.get(idx);
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
        }
        return answer != null ? answer : defaultValue;
    }

    private static Method findBestSetterMethod(Class clazz, String name, boolean fluentBuilder) {
        Set<Method> candidates = IntrospectionSupport.findSetterMethods(clazz, name, false);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if (fluentBuilder && (candidates = IntrospectionSupport.findSetterMethods(clazz, name, true)).size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    private static Class getGetterType(Object target, String name) {
        try {
            Method getter = IntrospectionSupport.getPropertyGetter(target.getClass(), name);
            if (getter != null) {
                return getter.getReturnType();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isComplexUserType(Class type) {
        return type != null && !type.isPrimitive() && !type.getName().startsWith("java");
    }

    private static void setReferenceProperties(CamelContext context, Object target, Map<String, Object> parameters) {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Object v;
            String value;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (name.contains(".") || name.contains("[") || name.contains("]") || !PropertyBindingSupport.isReferenceParameter(value = (v = entry.getValue()) != null ? v.toString() : null)) continue;
            try {
                boolean hit = IntrospectionSupport.setProperty(context, context.getTypeConverter(), target, name, null, value, true);
                if (!hit) continue;
                it.remove();
            }
            catch (Exception e) {
                throw new PropertyBindingException(target, e);
            }
        }
    }

    private static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    @FunctionalInterface
    public static interface OnAutowiring {
        public void onAutowire(Object var1, String var2, Class var3, Object var4);
    }

    public static class Builder {
        private boolean nesting = true;
        private boolean deepNesting = true;
        private boolean reference = true;
        private boolean placeholder = true;
        private boolean fluentBuilder = true;

        public Builder withNesting(boolean nesting) {
            this.nesting = nesting;
            return this;
        }

        public Builder withDeepNesting(boolean deepNesting) {
            this.deepNesting = deepNesting;
            return this;
        }

        public Builder withReference(boolean reference) {
            this.reference = reference;
            return this;
        }

        public Builder withPlaceholder(boolean placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder withFluentBuilder(boolean fluentBuilder) {
            this.fluentBuilder = fluentBuilder;
            return this;
        }

        public boolean bind(CamelContext camelContext, Object target, Map<String, Object> properties) {
            org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
            org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
            org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
            return PropertyBindingSupport.bindProperties(camelContext, target, properties, this.nesting, this.deepNesting, this.fluentBuilder, this.reference, this.placeholder);
        }
    }
}

