/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.maven;

public final class MavenGav {
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "jar";
    private String classifier = "";

    public static MavenGav parseGav(String gav) {
        return MavenGav.parseGav(gav, null);
    }

    public static MavenGav fromCoordinates(String groupId, String artifactId, String version, String packaging, String classifier) {
        MavenGav answer = new MavenGav();
        answer.groupId = groupId;
        answer.artifactId = artifactId;
        answer.version = version;
        if (classifier != null && !"".equals(classifier)) {
            answer.classifier = classifier;
        }
        if (packaging != null && !"".equals(packaging)) {
            answer.packaging = packaging;
        }
        return answer;
    }

    public static MavenGav parseGav(String gav, String defaultVersion) {
        MavenGav answer = new MavenGav();
        if (gav.startsWith("camel:")) {
            answer.setGroupId("org.apache.camel");
            Object a = gav.substring(6);
            if (((String)a).startsWith("camel-quarkus-")) {
                a = "camel-" + ((String)a).substring(14);
            }
            if (!((String)a).startsWith("camel-")) {
                a = "camel-" + (String)a;
            }
            answer.setArtifactId((String)a);
            if (defaultVersion != null) {
                answer.setVersion(defaultVersion);
            }
        } else if (gav.startsWith("camel-") && !gav.contains(":") && !gav.contains("/")) {
            answer.setGroupId("org.apache.camel");
            Object a = gav;
            if (((String)a).startsWith("camel-quarkus-")) {
                a = "camel-" + ((String)a).substring(14);
            }
            answer.setArtifactId((String)a);
            if (defaultVersion != null) {
                answer.setVersion(defaultVersion);
            }
        } else if (gav.startsWith("org.apache.camel:")) {
            String[] parts = gav.split(":");
            if (parts.length > 0) {
                answer.setGroupId(parts[0]);
            }
            if (parts.length > 1) {
                answer.setArtifactId(parts[1]);
            }
            if (parts.length > 2) {
                answer.setVersion(parts[2]);
            } else if (defaultVersion != null) {
                answer.setVersion(defaultVersion);
            }
        } else {
            String[] parts;
            String[] stringArray = parts = gav.startsWith("mvn:") ? gav.substring(4).split(":") : gav.split(":");
            if (parts.length > 0) {
                answer.setGroupId(parts[0]);
            }
            if (parts.length > 1) {
                answer.setArtifactId(parts[1]);
            }
            if (parts.length > 2) {
                if (parts.length == 3) {
                    answer.setVersion(parts[2]);
                } else if (parts.length == 4) {
                    answer.setPackaging(parts[2]);
                    answer.setVersion(parts[3]);
                } else if (parts.length == 5) {
                    answer.setPackaging(parts[2]);
                    answer.setClassifier(parts[3]);
                    answer.setVersion(parts[4]);
                }
            }
        }
        return answer;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String toString() {
        if (this.version != null) {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }
        return this.groupId + ":" + this.artifactId;
    }
}

