/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.io.Serializable;
import java.util.UUID;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class DefaultWebsocket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebsocket.class);
    private final WebsocketConsumer consumer;
    private final NodeSynchronization sync;
    private Session session;
    private String connectionKey;

    public DefaultWebsocket(NodeSynchronization sync, WebsocketConsumer consumer) {
        this.sync = sync;
        this.consumer = consumer;
    }

    @OnWebSocketClose
    public void onClose(int closeCode, String message) {
        LOG.trace("onClose {} {}", (Object)closeCode, (Object)message);
        this.sync.removeSocket(this);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOG.trace("onConnect {}", (Object)session);
        this.session = session;
        this.connectionKey = UUID.randomUUID().toString();
        this.sync.addSocket(this);
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        LOG.debug("onMessage: {}", (Object)message);
        if (this.consumer != null) {
            this.consumer.sendMessage(this.connectionKey, message);
        } else {
            LOG.debug("No consumer to handle message received: {}", (Object)message);
        }
    }

    @OnWebSocketMessage
    public void onMessage(byte[] data, int offset, int length) {
        LOG.debug("onMessage: byte[]");
        if (this.consumer != null) {
            byte[] message = new byte[length];
            System.arraycopy(data, offset, message, 0, length);
            this.consumer.sendMessage(this.connectionKey, message);
        } else {
            LOG.debug("No consumer to handle message received: byte[]");
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public void setConnectionKey(String connectionKey) {
        this.connectionKey = connectionKey;
    }
}

