/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.websocket.WebsocketComponent;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.apache.camel.component.websocket.WebsocketProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.server.Handler;

@UriEndpoint(scheme="websocket", title="Jetty Websocket", syntax="websocket:host:port/resourceUri", consumerClass=WebsocketConsumer.class, label="websocket")
public class WebsocketEndpoint
extends DefaultEndpoint {
    private WebsocketComponent component;
    private URI uri;
    private List<Handler> handlers;
    @UriPath(defaultValue="0.0.0.0")
    private String host;
    @UriPath(defaultValue="9292")
    private Integer port;
    @UriPath
    @Metadata(required="true")
    private String resourceUri;
    @UriParam(label="producer")
    private Boolean sendToAll;
    @UriParam(label="producer", defaultValue="30000")
    private Integer sendTimeout = 30000;
    @UriParam(label="monitoring")
    private boolean enableJmx;
    @UriParam(label="consumer")
    private boolean sessionSupport;
    @UriParam(label="cors")
    private boolean crossOriginFilterOn;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="cors")
    private String allowedOrigins;
    @UriParam(label="cors")
    private String filterPath;
    @UriParam(label="consumer")
    private String staticResources;
    @UriParam(label="advanced", defaultValue="8192")
    private Integer bufferSize;
    @UriParam(label="advanced", defaultValue="300000")
    private Integer maxIdleTime;
    @UriParam(label="advanced")
    private Integer maxTextMessageSize;
    @UriParam(defaultValue="-1")
    private Integer maxBinaryMessageSize;
    @UriParam(label="advanced", defaultValue="13")
    private Integer minVersion;

    public WebsocketEndpoint(WebsocketComponent component, String uri, String resourceUri, Map<String, Object> parameters) {
        super(uri, (Component)component);
        this.resourceUri = resourceUri;
        this.component = component;
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public WebsocketComponent getComponent() {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        return (WebsocketComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        WebsocketConsumer consumer = new WebsocketConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        return new WebsocketProducer(this);
    }

    public void connect(WebsocketConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(WebsocketConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public void connect(WebsocketProducer producer) throws Exception {
        this.component.connect(producer);
    }

    public void disconnect(WebsocketProducer producer) throws Exception {
        this.component.disconnect(producer);
    }

    public boolean isSingleton() {
        return true;
    }

    public URI getUri() {
        return this.uri;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getStaticResources() {
        return this.staticResources;
    }

    public void setStaticResources(String staticResources) {
        this.staticResources = staticResources;
    }

    public Boolean getSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(Boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public Integer getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(Integer sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public String getProtocol() {
        return this.uri.getScheme();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public void setSessionSupport(boolean support) {
        this.sessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Integer getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(Integer maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public Integer getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setMaxTextMessageSize(Integer maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }

    public Integer getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(Integer maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public Integer getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(Integer minVersion) {
        this.minVersion = minVersion;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public boolean isCrossOriginFilterOn() {
        return this.crossOriginFilterOn;
    }

    public void setCrossOriginFilterOn(boolean crossOriginFilterOn) {
        this.crossOriginFilterOn = crossOriginFilterOn;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

