/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WebsocketEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/resourceUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "websocket".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", "0.0.0.0", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", "9292", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "resourceUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("allowedOrigins");
        props.add("bridgeErrorHandler");
        props.add("bufferSize");
        props.add("crossOriginFilterOn");
        props.add("enableJmx");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("filterPath");
        props.add("host");
        props.add("lazyStartProducer");
        props.add("maxBinaryMessageSize");
        props.add("maxIdleTime");
        props.add("maxTextMessageSize");
        props.add("minVersion");
        props.add("port");
        props.add("resourceUri");
        props.add("sendTimeout");
        props.add("sendToAll");
        props.add("sessionSupport");
        props.add("sslContextParameters");
        props.add("staticResources");
        props.add("subprotocol");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

