/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xj;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.component.xj.XJConstants;

public class XmlJsonStreamWriter
implements XMLStreamWriter {
    private final JsonGenerator jsonGenerator;
    private TreeElement treeRoot;
    private TreeElement currentTreeElement;

    public XmlJsonStreamWriter(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    @Override
    public void writeStartElement(String localName) {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        this.writeStartElement(null, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        TreeElement treeElement = new TreeElement(this.currentTreeElement, 1, localName);
        this.currentTreeElement.addChild(treeElement);
        this.currentTreeElement = treeElement;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        this.writeStartElement(null, namespaceURI, localName);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.writeStartElement(null, localName, null);
        this.writeEndElement();
    }

    @Override
    public void writeEndElement() {
        this.currentTreeElement.writeEnd();
        this.currentTreeElement = this.currentTreeElement.parent;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            this.treeRoot.write(this.jsonGenerator);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.jsonGenerator.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        if ("http://camel.apache.org/component/xj".equals(namespaceURI)) {
            switch (localName) {
                case "name": {
                    this.currentTreeElement.setName(value);
                    return;
                }
                case "type": {
                    this.currentTreeElement.setJsonToken(XJConstants.TYPE_JSONTYPE_MAP.get(value));
                    return;
                }
            }
            return;
        }
        TreeElement treeElement = new TreeElement(this.currentTreeElement, 10, JsonToken.VALUE_STRING, localName);
        treeElement.setValue(value);
        this.currentTreeElement.addChild(treeElement);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
    }

    @Override
    public void writeComment(String data) {
    }

    @Override
    public void writeProcessingInstruction(String target) {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
    }

    @Override
    public void writeCData(String data) {
        this.writeCharacters(data);
    }

    @Override
    public void writeDTD(String dtd) {
    }

    @Override
    public void writeEntityRef(String name) {
    }

    @Override
    public void writeStartDocument() {
        this.writeStartDocument(null);
    }

    @Override
    public void writeStartDocument(String version) {
        this.writeStartDocument(null, version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        TreeElement treeElement;
        this.treeRoot = treeElement = new TreeElement(null, 7, JsonToken.NOT_AVAILABLE);
        this.currentTreeElement = treeElement;
    }

    @Override
    public void writeCharacters(String text) {
        TreeElement child;
        List<TreeElement> childs = this.currentTreeElement.childs;
        if (!childs.isEmpty() && (child = childs.get(childs.size() - 1)).getXmlEvent() == 4) {
            child.appendValue(text);
            return;
        }
        TreeElement treeElement = new TreeElement(this.currentTreeElement, 4, JsonToken.VALUE_STRING);
        treeElement.setValue(text);
        this.currentTreeElement.addChild(treeElement);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public String getPrefix(String uri) {
        return null;
    }

    @Override
    public void setPrefix(String prefix, String uri) {
    }

    @Override
    public void setDefaultNamespace(String uri) {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException("unsupported / not yet implemented");
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name + " unsupported");
    }

    private static class TreeElement {
        private TreeElement parent;
        private List<TreeElement> childs = Collections.emptyList();
        private String name;
        private String value;
        private int xmlEvent;
        private JsonToken jsonToken;

        TreeElement(TreeElement parent, int xmlEvent, String name) {
            this.parent = parent;
            this.xmlEvent = xmlEvent;
            this.name = name;
        }

        TreeElement(TreeElement parent, int xmlEvent, JsonToken jsonToken) {
            this.parent = parent;
            this.xmlEvent = xmlEvent;
            this.jsonToken = jsonToken;
        }

        TreeElement(TreeElement parent, int xmlEvent, JsonToken jsonToken, String name) {
            this.parent = parent;
            this.xmlEvent = xmlEvent;
            this.jsonToken = jsonToken;
            this.name = name;
        }

        int getXmlEvent() {
            return this.xmlEvent;
        }

        void addChild(TreeElement treeElement) {
            if (this.childs.equals(Collections.emptyList())) {
                this.childs = new ArrayList<TreeElement>(1);
            }
            this.childs.add(treeElement);
        }

        void setJsonToken(JsonToken jsonToken) {
            if (this.jsonToken == null) {
                this.jsonToken = jsonToken;
            }
        }

        void setName(String name) {
            this.name = name;
        }

        void setValue(String value) {
            this.value = value;
        }

        void appendValue(String value) {
            this.value = this.value + value;
        }

        void writeEnd() {
            if (this.jsonToken == null) {
                this.writeEndNoTypeHints();
            } else {
                this.writeEndHaveTypeHints();
            }
        }

        private void writeEndNoTypeHints() {
            if (this.xmlEvent == 1) {
                if (this.childs.isEmpty()) {
                    if (this.parent.jsonToken == JsonToken.NOT_AVAILABLE) {
                        this.jsonToken = JsonToken.START_OBJECT;
                    } else {
                        this.jsonToken = JsonToken.FIELD_NAME;
                        TreeElement treeElement = new TreeElement(this, -1, JsonToken.VALUE_STRING);
                        treeElement.setValue("");
                        this.addChild(treeElement);
                    }
                } else if (this.childs.size() == 1 && this.childs.get((int)0).xmlEvent == 4) {
                    if (this.parent.jsonToken == JsonToken.NOT_AVAILABLE) {
                        this.jsonToken = JsonToken.START_OBJECT;
                        TreeElement child = this.childs.get(0);
                        if (this.isWhitespace(child.value)) {
                            this.childs.remove(0);
                        } else {
                            TreeElement treeElement = new TreeElement(this, -1, JsonToken.FIELD_NAME, "#text");
                            treeElement.addChild(child);
                            this.childs.set(this.childs.indexOf(child), treeElement);
                            child.parent = treeElement;
                        }
                    } else {
                        this.jsonToken = JsonToken.FIELD_NAME;
                    }
                } else {
                    Iterator<TreeElement> iterator = this.childs.iterator();
                    while (iterator.hasNext()) {
                        TreeElement element = iterator.next();
                        if (element.jsonToken != JsonToken.VALUE_STRING) continue;
                        if (this.isWhitespace(element.value)) {
                            iterator.remove();
                            continue;
                        }
                        TreeElement treeElement = new TreeElement(this, -1, JsonToken.FIELD_NAME, element.name != null ? element.name : "#text");
                        treeElement.addChild(element);
                        this.childs.set(this.childs.indexOf(element), treeElement);
                        element.parent = treeElement;
                        element.jsonToken = JsonToken.VALUE_STRING;
                    }
                    this.jsonToken = JsonToken.START_OBJECT;
                    this.wrapChildsInArrayIfNecessary();
                }
            } else {
                throw new IllegalStateException("XMLEvent: " + this.xmlEvent + "; Json Token: " + this.jsonToken);
            }
        }

        private void writeEndHaveTypeHints() {
            switch (this.jsonToken) {
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    if (this.childs.isEmpty()) {
                        TreeElement treeElement = new TreeElement(this, -1, this.jsonToken);
                        treeElement.setValue("");
                        this.addChild(treeElement);
                        this.jsonToken = JsonToken.FIELD_NAME;
                        break;
                    }
                    if (this.childs.size() == 1) {
                        this.childs.get((int)0).jsonToken = this.jsonToken;
                        this.jsonToken = JsonToken.FIELD_NAME;
                        break;
                    }
                    Iterator<TreeElement> iterator = this.childs.iterator();
                    while (iterator.hasNext()) {
                        TreeElement element = iterator.next();
                        if (!this.isValueToken(element.jsonToken)) continue;
                        if (this.isWhitespace(element.value)) {
                            iterator.remove();
                            continue;
                        }
                        TreeElement treeElement = new TreeElement(this, -1, JsonToken.FIELD_NAME, element.name != null ? element.name : "#text");
                        treeElement.addChild(element);
                        this.childs.set(this.childs.indexOf(element), treeElement);
                        element.parent = treeElement;
                        if (element.xmlEvent != 4) continue;
                        element.jsonToken = this.jsonToken;
                    }
                    this.jsonToken = JsonToken.START_OBJECT;
                    this.wrapChildsInArrayIfNecessary();
                    break;
                }
                case START_OBJECT: 
                case START_ARRAY: {
                    Iterator<TreeElement> iterator = this.childs.iterator();
                    while (iterator.hasNext()) {
                        TreeElement element = iterator.next();
                        if (!this.isValueToken(element.jsonToken)) continue;
                        if (this.isWhitespace(element.value)) {
                            iterator.remove();
                            continue;
                        }
                        TreeElement treeElement = new TreeElement(this, -1, JsonToken.FIELD_NAME, "#text");
                        treeElement.addChild(element);
                        this.childs.set(this.childs.indexOf(element), treeElement);
                        element.parent = treeElement;
                    }
                    if (this.jsonToken == JsonToken.START_ARRAY) break;
                    this.wrapChildsInArrayIfNecessary();
                    break;
                }
                default: {
                    throw new IllegalStateException("XMLEvent: " + this.xmlEvent + "; Json Token: " + this.jsonToken);
                }
            }
        }

        private void wrapChildsInArrayIfNecessary() {
            Map childElementsMap = this.childs.stream().collect(Collectors.groupingBy(o -> o.name, HashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            for (Map.Entry mapEntry : childElementsMap.entrySet()) {
                if (((Set)mapEntry.getValue()).size() <= 1) continue;
                if (childElementsMap.size() == 1) {
                    this.jsonToken = JsonToken.START_ARRAY;
                    continue;
                }
                TreeElement treeElement = new TreeElement(this, -1, JsonToken.START_ARRAY, (String)mapEntry.getKey());
                treeElement.childs = new ArrayList<TreeElement>((Collection)mapEntry.getValue());
                for (TreeElement child : treeElement.childs) {
                    child.parent = treeElement;
                }
                ArrayList<TreeElement> newChildList = new ArrayList<TreeElement>(this.childs.size() - ((Set)mapEntry.getValue()).size() + 1);
                for (TreeElement e : this.childs) {
                    if (((Set)mapEntry.getValue()).contains(e)) continue;
                    newChildList.add(e);
                }
                this.childs = newChildList;
                this.childs.add(treeElement);
            }
        }

        private boolean isWhitespace(String text) {
            int st;
            int len = text.length();
            for (st = 0; st < len && text.charAt(st) <= ' '; ++st) {
            }
            return st == len;
        }

        private boolean isValueToken(JsonToken jsonToken) {
            return jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_NUMBER_FLOAT || jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_TRUE || jsonToken == JsonToken.VALUE_FALSE || jsonToken == JsonToken.VALUE_NULL;
        }

        void write(JsonGenerator jsonGenerator) throws IOException {
            switch (this.jsonToken) {
                case NOT_AVAILABLE: {
                    break;
                }
                case START_OBJECT: {
                    if (this.parent.jsonToken == JsonToken.START_OBJECT) {
                        jsonGenerator.writeObjectFieldStart(this.name);
                        break;
                    }
                    jsonGenerator.writeStartObject();
                    break;
                }
                case START_ARRAY: {
                    if (this.parent.jsonToken == JsonToken.START_OBJECT) {
                        jsonGenerator.writeArrayFieldStart(this.name);
                        break;
                    }
                    jsonGenerator.writeStartArray();
                    break;
                }
                case FIELD_NAME: {
                    if (this.parent.jsonToken == JsonToken.START_ARRAY) break;
                    jsonGenerator.writeFieldName(this.name);
                    break;
                }
                case VALUE_STRING: {
                    jsonGenerator.writeString(this.value);
                    break;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    if (this.value == null || this.value.isEmpty()) {
                        jsonGenerator.writeNull();
                        break;
                    }
                    jsonGenerator.writeRawValue(this.value);
                    break;
                }
                case VALUE_NULL: {
                    jsonGenerator.writeNull();
                    break;
                }
                default: {
                    throw new IllegalStateException("XMLEvent: " + this.xmlEvent + "; Json Token: " + this.jsonToken);
                }
            }
            for (TreeElement treeElement : this.childs) {
                treeElement.write(jsonGenerator);
            }
            switch (this.jsonToken) {
                case START_OBJECT: {
                    jsonGenerator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    jsonGenerator.writeEndArray();
                    break;
                }
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case NOT_AVAILABLE: 
                case FIELD_NAME: {
                    break;
                }
                default: {
                    throw new IllegalStateException("XMLEvent: " + this.xmlEvent + "; Json Token: " + this.jsonToken);
                }
            }
        }

        public String toString() {
            return "TreeElement{name='" + this.name + "', value='" + this.value + "', xmlEvent=" + this.xmlEvent + ", jsonToken=" + this.jsonToken + "}";
        }
    }
}

