/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.saxon.XsltSaxonBuilder;
import org.apache.camel.component.xslt.saxon.XsltSaxonComponent;
import org.apache.camel.component.xslt.saxon.XsltSaxonHelper;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@ManagedResource(description="Managed XsltSaxonEndpoint")
@UriEndpoint(firstVersion="3.0.0", scheme="xslt-saxon", title="XSLT Saxon", syntax="xslt-saxon:resourceUri", producerOnly=true, category={Category.CORE, Category.TRANSFORMATION})
public class XsltSaxonEndpoint
extends XsltEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(XsltSaxonEndpoint.class);
    @UriParam(label="advanced")
    private Configuration saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @Metadata(label="advanced")
    private Map<String, Object> saxonReaderProperties = new HashMap<String, Object>();
    @UriParam(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;
    @UriParam(displayName="Allow StAX", defaultValue="true")
    private boolean allowStAX = true;
    @UriParam(label="advanced", defaultValue="true")
    private boolean secureProcessing = true;

    public XsltSaxonEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter((CamelContext)this.getCamelContext(), (String)extensionFunctions, Object.class);
    }

    public Configuration getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Configuration saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    public Map<String, Object> getSaxonReaderProperties() {
        return this.saxonReaderProperties;
    }

    public void setSaxonReaderProperties(Map<String, Object> saxonReaderProperties) {
        this.saxonReaderProperties = saxonReaderProperties;
    }

    @ManagedAttribute(description="Whether to allow using StAX as the javax.xml.transform.Source")
    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.setXslt(this.createXsltBuilder());
        if (this.isContentCache() && ResourceHelper.isClasspathUri((String)this.getResourceUri())) {
            this.loadResource(this.getResourceUri(), this.getXslt());
        }
        this.setProcessor((Processor)this.getXslt());
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isContentCache() && !ResourceHelper.isClasspathUri((String)this.getResourceUri())) {
            this.loadResource(this.getResourceUri(), this.getXslt());
        }
    }

    protected XsltSaxonBuilder createXsltBuilder() throws Exception {
        CamelContext ctx = this.getCamelContext();
        ClassResolver resolver = ctx.getClassResolver();
        Injector injector = ctx.getInjector();
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)this.getResourceUri());
        XsltSaxonBuilder xslt = (XsltSaxonBuilder)((Object)injector.newInstance(XsltSaxonBuilder.class));
        TransformerFactory factory = this.getTransformerFactory();
        if (factory == null) {
            if (this.getTransformerFactoryClass() == null) {
                factory = new TransformerFactoryImpl();
            } else {
                Class factoryClass = resolver.resolveMandatoryClass(this.getTransformerFactoryClass(), TransformerFactory.class, XsltSaxonComponent.class.getClassLoader());
                LOG.debug("Using TransformerFactoryClass {}", (Object)factoryClass);
                factory = (TransformerFactory)injector.newInstance(factoryClass);
            }
        }
        if (factory instanceof TransformerFactoryImpl) {
            TransformerFactoryImpl tf = (TransformerFactoryImpl)factory;
            XsltSaxonHelper.registerSaxonConfiguration(tf, this.saxonConfiguration);
            XsltSaxonHelper.registerSaxonConfigurationProperties(tf, this.saxonConfigurationProperties);
            XsltSaxonHelper.registerSaxonExtensionFunctions(tf, this.saxonExtensionFunctions, this.secureProcessing);
        }
        if (factory != null) {
            LOG.debug("Using TransformerFactory {}", (Object)factory);
            xslt.setTransformerFactory(factory);
        }
        if (this.getResultHandlerFactory() != null) {
            xslt.setResultHandlerFactory(this.getResultHandlerFactory());
        }
        if (this.getErrorListener() != null) {
            xslt.errorListener(this.getErrorListener());
        }
        xslt.setFailOnNullBody(this.isFailOnNullBody());
        xslt.transformerCacheSize(this.getTransformerCacheSize());
        xslt.setUriResolver(this.getUriResolver());
        xslt.setEntityResolver(this.getEntityResolver());
        xslt.setAllowStAX(this.allowStAX);
        xslt.setDeleteOutputFile(this.isDeleteOutputFile());
        if (this.getXsltMessageLogger() != null) {
            xslt.setXsltMessageLogger(this.getXsltMessageLogger());
        }
        this.configureOutput(xslt, this.getOutput().name());
        if (this.getParameters() != null) {
            HashMap copy = new HashMap(this.getParameters());
            xslt.setParameters(copy);
        }
        return xslt;
    }

    protected XsltBuilder createBuilderForCustomStylesheet(String template, Exchange exchange) throws Exception {
        InputStream is = (InputStream)this.getCamelContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, (Object)template);
        XsltSaxonBuilder builder = this.createXsltBuilder();
        Source source = new StreamSource(is);
        if (this.saxonReaderProperties != null) {
            source = this.createReaderForSource(source);
        }
        builder.setTransformerSource(source);
        return builder;
    }

    protected void loadResource(String resourceUri, XsltBuilder xslt) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = xslt.getUriResolver().resolve(resourceUri, null);
        if (this.saxonReaderProperties != null) {
            source = this.createReaderForSource(source);
        }
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        xslt.setTransformerSource(source);
        this.setCacheCleared(false);
    }

    private Source createReaderForSource(Source source) {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            for (Map.Entry<String, Object> entry : this.saxonReaderProperties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                try {
                    URI uri = new URI(key);
                    if (value != null && (value.toString().equals("true") || value.toString().equals("false"))) {
                        xmlReader.setFeature(uri.toString(), Boolean.valueOf(value.toString()));
                        continue;
                    }
                    if (value == null) continue;
                    xmlReader.setProperty(uri.toString(), value);
                }
                catch (URISyntaxException e) {
                    LOG.debug("{} isn't a valid URI, so ingore it", (Object)key);
                }
            }
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            return new SAXSource(xmlReader, inputSource);
        }
        catch (SAXException e) {
            LOG.info("Can't created XMLReader for source ", (Throwable)e);
            return null;
        }
    }
}

