/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.Map;
import javax.xml.transform.URIResolver;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xslt.DefaultXsltUriResolverFactory;
import org.apache.camel.component.xslt.TransformerFactoryConfigurationStrategy;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.XsltUriResolverFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="xslt")
public class XsltComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(XsltComponent.class);
    @Metadata(label="advanced")
    private URIResolver uriResolver;
    @Metadata(label="advanced")
    private XsltUriResolverFactory uriResolverFactory;
    @Metadata(defaultValue="true")
    private boolean contentCache = true;
    @Metadata(label="advanced")
    private TransformerFactoryConfigurationStrategy transformerFactoryConfigurationStrategy;
    @Metadata(label="advanced")
    private String transformerFactoryClass;

    public XsltUriResolverFactory getUriResolverFactory() {
        return this.uriResolverFactory;
    }

    public void setUriResolverFactory(XsltUriResolverFactory uriResolverFactory) {
        this.uriResolverFactory = uriResolverFactory;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public TransformerFactoryConfigurationStrategy getTransformerFactoryConfigurationStrategy() {
        return this.transformerFactoryConfigurationStrategy;
    }

    public void setTransformerFactoryConfigurationStrategy(TransformerFactoryConfigurationStrategy transformerFactoryConfigurationStrategy) {
        this.transformerFactoryConfigurationStrategy = transformerFactoryConfigurationStrategy;
    }

    public String getTransformerFactoryClass() {
        return this.transformerFactoryClass;
    }

    public void setTransformerFactoryClass(String transformerFactoryClass) {
        this.transformerFactoryClass = transformerFactoryClass;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XsltEndpoint endpoint = this.createXsltEndpoint(uri);
        this.configureEndpoint((Endpoint)endpoint, remaining, parameters);
        return endpoint;
    }

    protected XsltEndpoint createXsltEndpoint(String uri) {
        return new XsltEndpoint(uri, (Component)this);
    }

    protected void configureEndpoint(Endpoint endpoint, String remaining, Map<String, Object> parameters) throws Exception {
        XsltEndpoint xslt = (XsltEndpoint)endpoint;
        xslt.setContentCache(this.isContentCache());
        URIResolver resolver = (URIResolver)this.resolveAndRemoveReferenceParameter(parameters, "uriResolver", URIResolver.class);
        if (resolver == null) {
            resolver = this.getUriResolver();
        }
        if (resolver == null) {
            XsltUriResolverFactory resolverFactory = (XsltUriResolverFactory)this.resolveAndRemoveReferenceParameter(parameters, "uriResolverFactory", XsltUriResolverFactory.class);
            if (resolverFactory == null) {
                resolverFactory = this.getUriResolverFactory();
            }
            if (resolverFactory == null) {
                resolverFactory = new DefaultXsltUriResolverFactory();
            }
            resolver = resolverFactory.createUriResolver(this.getCamelContext(), remaining);
        }
        xslt.setUriResolver(resolver);
        this.setProperties(endpoint, parameters);
        String resourceUri = remaining;
        if (ResourceHelper.isHttpUri((String)resourceUri)) {
            resourceUri = ResourceHelper.appendParameters((String)resourceUri, parameters);
        }
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        xslt.setResourceUri(resourceUri);
        if (!parameters.isEmpty()) {
            xslt.setParameters(parameters);
        }
    }
}

