/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class IndexClause
implements TBase<IndexClause, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("IndexClause");
    private static final TField EXPRESSIONS_FIELD_DESC = new TField("expressions", 15, 1);
    private static final TField START_KEY_FIELD_DESC = new TField("start_key", 11, 2);
    private static final TField COUNT_FIELD_DESC = new TField("count", 8, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public List<IndexExpression> expressions;
    public ByteBuffer start_key;
    public int count;
    private static final int __COUNT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public IndexClause() {
        this.count = 100;
    }

    public IndexClause(List<IndexExpression> expressions, ByteBuffer start_key, int count) {
        this();
        this.expressions = expressions;
        this.start_key = start_key;
        this.count = count;
        this.setCountIsSet(true);
    }

    public IndexClause(IndexClause other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetExpressions()) {
            ArrayList<IndexExpression> __this__expressions = new ArrayList<IndexExpression>();
            for (IndexExpression other_element : other.expressions) {
                __this__expressions.add(new IndexExpression(other_element));
            }
            this.expressions = __this__expressions;
        }
        if (other.isSetStart_key()) {
            this.start_key = TBaseHelper.copyBinary((ByteBuffer)other.start_key);
        }
        this.count = other.count;
    }

    public IndexClause deepCopy() {
        return new IndexClause(this);
    }

    public void clear() {
        this.expressions = null;
        this.start_key = null;
        this.count = 100;
    }

    public int getExpressionsSize() {
        return this.expressions == null ? 0 : this.expressions.size();
    }

    public Iterator<IndexExpression> getExpressionsIterator() {
        return this.expressions == null ? null : this.expressions.iterator();
    }

    public void addToExpressions(IndexExpression elem) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<IndexExpression>();
        }
        this.expressions.add(elem);
    }

    public List<IndexExpression> getExpressions() {
        return this.expressions;
    }

    public IndexClause setExpressions(List<IndexExpression> expressions) {
        this.expressions = expressions;
        return this;
    }

    public void unsetExpressions() {
        this.expressions = null;
    }

    public boolean isSetExpressions() {
        return this.expressions != null;
    }

    public void setExpressionsIsSet(boolean value) {
        if (!value) {
            this.expressions = null;
        }
    }

    public byte[] getStart_key() {
        this.setStart_key(TBaseHelper.rightSize((ByteBuffer)this.start_key));
        return this.start_key == null ? null : this.start_key.array();
    }

    public ByteBuffer bufferForStart_key() {
        return this.start_key;
    }

    public IndexClause setStart_key(byte[] start_key) {
        this.setStart_key(start_key == null ? (ByteBuffer)null : ByteBuffer.wrap(start_key));
        return this;
    }

    public IndexClause setStart_key(ByteBuffer start_key) {
        this.start_key = start_key;
        return this;
    }

    public void unsetStart_key() {
        this.start_key = null;
    }

    public boolean isSetStart_key() {
        return this.start_key != null;
    }

    public void setStart_keyIsSet(boolean value) {
        if (!value) {
            this.start_key = null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public IndexClause setCount(int count) {
        this.count = count;
        this.setCountIsSet(true);
        return this;
    }

    public void unsetCount() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCount() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCountIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case EXPRESSIONS: {
                if (value == null) {
                    this.unsetExpressions();
                    break;
                }
                this.setExpressions((List)value);
                break;
            }
            case START_KEY: {
                if (value == null) {
                    this.unsetStart_key();
                    break;
                }
                this.setStart_key((ByteBuffer)value);
                break;
            }
            case COUNT: {
                if (value == null) {
                    this.unsetCount();
                    break;
                }
                this.setCount((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case EXPRESSIONS: {
                return this.getExpressions();
            }
            case START_KEY: {
                return this.getStart_key();
            }
            case COUNT: {
                return this.getCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case EXPRESSIONS: {
                return this.isSetExpressions();
            }
            case START_KEY: {
                return this.isSetStart_key();
            }
            case COUNT: {
                return this.isSetCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof IndexClause) {
            return this.equals((IndexClause)that);
        }
        return false;
    }

    public boolean equals(IndexClause that) {
        if (that == null) {
            return false;
        }
        boolean this_present_expressions = this.isSetExpressions();
        boolean that_present_expressions = that.isSetExpressions();
        if (this_present_expressions || that_present_expressions) {
            if (!this_present_expressions || !that_present_expressions) {
                return false;
            }
            if (!this.expressions.equals(that.expressions)) {
                return false;
            }
        }
        boolean this_present_start_key = this.isSetStart_key();
        boolean that_present_start_key = that.isSetStart_key();
        if (this_present_start_key || that_present_start_key) {
            if (!this_present_start_key || !that_present_start_key) {
                return false;
            }
            if (!this.start_key.equals(that.start_key)) {
                return false;
            }
        }
        boolean this_present_count = true;
        boolean that_present_count = true;
        if (this_present_count || that_present_count) {
            if (!this_present_count || !that_present_count) {
                return false;
            }
            if (this.count != that.count) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_expressions = this.isSetExpressions();
        builder.append(present_expressions);
        if (present_expressions) {
            builder.append(this.expressions);
        }
        boolean present_start_key = this.isSetStart_key();
        builder.append(present_start_key);
        if (present_start_key) {
            builder.append((Object)this.start_key);
        }
        boolean present_count = true;
        builder.append(present_count);
        if (present_count) {
            builder.append(this.count);
        }
        return builder.toHashCode();
    }

    public int compareTo(IndexClause other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        IndexClause typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetExpressions()).compareTo(typedOther.isSetExpressions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExpressions() && (lastComparison = TBaseHelper.compareTo(this.expressions, typedOther.expressions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStart_key()).compareTo(typedOther.isSetStart_key());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStart_key() && (lastComparison = TBaseHelper.compareTo((Comparable)this.start_key, (Comparable)typedOther.start_key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCount()).compareTo(typedOther.isSetCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCount() && (lastComparison = TBaseHelper.compareTo((int)this.count, (int)typedOther.count)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexClause(");
        boolean first = true;
        sb.append("expressions:");
        if (this.expressions == null) {
            sb.append("null");
        } else {
            sb.append(this.expressions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("start_key:");
        if (this.start_key == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.start_key, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("count:");
        sb.append(this.count);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.expressions == null) {
            throw new TProtocolException("Required field 'expressions' was not present! Struct: " + this.toString());
        }
        if (this.start_key == null) {
            throw new TProtocolException("Required field 'start_key' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new IndexClauseStandardSchemeFactory());
        schemes.put(TupleScheme.class, new IndexClauseTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.EXPRESSIONS, new FieldMetaData("expressions", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IndexExpression.class))));
        tmpMap.put(_Fields.START_KEY, new FieldMetaData("start_key", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COUNT, new FieldMetaData("count", 1, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(IndexClause.class, metaDataMap);
    }

    private static class IndexClauseTupleScheme
    extends TupleScheme<IndexClause> {
        private IndexClauseTupleScheme() {
        }

        public void write(TProtocol prot, IndexClause struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.expressions.size());
            for (IndexExpression _iter28 : struct.expressions) {
                _iter28.write((TProtocol)oprot);
            }
            oprot.writeBinary(struct.start_key);
            oprot.writeI32(struct.count);
        }

        public void read(TProtocol prot, IndexClause struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list29 = new TList(12, iprot.readI32());
            struct.expressions = new ArrayList<IndexExpression>(_list29.size);
            for (int _i30 = 0; _i30 < _list29.size; ++_i30) {
                IndexExpression _elem31 = new IndexExpression();
                _elem31.read((TProtocol)iprot);
                struct.expressions.add(_elem31);
            }
            struct.setExpressionsIsSet(true);
            struct.start_key = iprot.readBinary();
            struct.setStart_keyIsSet(true);
            struct.count = iprot.readI32();
            struct.setCountIsSet(true);
        }
    }

    private static class IndexClauseTupleSchemeFactory
    implements SchemeFactory {
        private IndexClauseTupleSchemeFactory() {
        }

        public IndexClauseTupleScheme getScheme() {
            return new IndexClauseTupleScheme();
        }
    }

    private static class IndexClauseStandardScheme
    extends StandardScheme<IndexClause> {
        private IndexClauseStandardScheme() {
        }

        public void read(TProtocol iprot, IndexClause struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list24 = iprot.readListBegin();
                            struct.expressions = new ArrayList<IndexExpression>(_list24.size);
                            for (int _i25 = 0; _i25 < _list24.size; ++_i25) {
                                IndexExpression _elem26 = new IndexExpression();
                                _elem26.read(iprot);
                                struct.expressions.add(_elem26);
                            }
                            iprot.readListEnd();
                            struct.setExpressionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.start_key = iprot.readBinary();
                            struct.setStart_keyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.count = iprot.readI32();
                            struct.setCountIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetCount()) {
                throw new TProtocolException("Required field 'count' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, IndexClause struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.expressions != null) {
                oprot.writeFieldBegin(EXPRESSIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.expressions.size()));
                for (IndexExpression _iter27 : struct.expressions) {
                    _iter27.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.start_key != null) {
                oprot.writeFieldBegin(START_KEY_FIELD_DESC);
                oprot.writeBinary(struct.start_key);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(COUNT_FIELD_DESC);
            oprot.writeI32(struct.count);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class IndexClauseStandardSchemeFactory
    implements SchemeFactory {
        private IndexClauseStandardSchemeFactory() {
        }

        public IndexClauseStandardScheme getScheme() {
            return new IndexClauseStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        EXPRESSIONS(1, "expressions"),
        START_KEY(2, "start_key"),
        COUNT(3, "count");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return EXPRESSIONS;
                }
                case 2: {
                    return START_KEY;
                }
                case 3: {
                    return COUNT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

