/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class DataDomainDBDiffBuilder
implements GraphChangeHandler {
    private ObjEntity objEntity;
    private DbEntity dbEntity;
    private Map currentPropertyDiff;
    private Map currentArcDiff;
    private Object currentId;

    DataDomainDBDiffBuilder() {
    }

    void reset(ObjEntity objEntity, DbEntity dbEntity) {
        this.objEntity = objEntity;
        this.dbEntity = dbEntity;
    }

    private void reset() {
        this.currentPropertyDiff = null;
        this.currentArcDiff = null;
        this.currentId = null;
    }

    Map buildDBDiff(GraphDiff singleObjectDiff) {
        this.reset();
        singleObjectDiff.apply(this);
        if (this.currentPropertyDiff == null && this.currentArcDiff == null && this.currentId == null) {
            return null;
        }
        HashMap dbDiff = new HashMap();
        this.appendSimpleProperties(dbDiff);
        this.appendForeignKeys(dbDiff);
        this.appendPrimaryKeys(dbDiff);
        return dbDiff.isEmpty() ? null : dbDiff;
    }

    private void appendSimpleProperties(Map dbDiff) {
        if (this.currentPropertyDiff != null) {
            Iterator it = this.currentPropertyDiff.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjAttribute attribute = (ObjAttribute)this.objEntity.getAttribute(entry.getKey().toString());
                Attribute dbAttribute = this.dbEntity.getAttribute(attribute.getDbAttributeName());
                dbDiff.put(dbAttribute.getName(), entry.getValue());
            }
        }
    }

    private void appendForeignKeys(Map dbDiff) {
        if (this.currentArcDiff != null) {
            Iterator it = this.currentArcDiff.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjRelationship relation = (ObjRelationship)this.objEntity.getRelationship(entry.getKey().toString());
                DbRelationship dbRelation = (DbRelationship)relation.getDbRelationships().get(0);
                ObjectId targetId = (ObjectId)entry.getValue();
                Iterator joins = dbRelation.getJoins().iterator();
                while (joins.hasNext()) {
                    DbJoin join = (DbJoin)joins.next();
                    DataDomainSyncBucket.PropagatedValueFactory value = targetId != null ? new DataDomainSyncBucket.PropagatedValueFactory(targetId, join.getTargetName()) : null;
                    dbDiff.put(join.getSourceName(), value);
                }
            }
        }
    }

    private void appendPrimaryKeys(Map dbDiff) {
        if (this.currentId != null) {
            dbDiff.putAll(((ObjectId)this.currentId).getIdSnapshot());
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        if (this.currentPropertyDiff == null) {
            this.currentPropertyDiff = new HashMap();
        }
        this.currentPropertyDiff.put(property, newValue);
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap();
            }
            this.currentArcDiff.put(arcId, targetNodeId);
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap();
                this.currentArcDiff.put(arcId, null);
            } else if (targetNodeId.equals(this.currentArcDiff.get(arcId))) {
                this.currentArcDiff.put(arcId, null);
            }
        }
    }

    public void nodeCreated(Object nodeId) {
        this.currentId = nodeId;
    }

    public void nodeRemoved(Object nodeId) {
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }
}

