/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNodeQueryAction;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionConnectionDecorator;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.AshwoodEntitySorter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.Query;

public class DataNode
implements QueryEngine {
    protected String name;
    protected DataSource dataSource;
    protected DbAdapter adapter;
    protected String dataSourceLocation;
    protected String dataSourceFactory;
    protected EntityResolver entityResolver;
    protected EntitySorter entitySorter;
    protected Map dataMaps;
    TransactionDataSource readThroughDataSource;

    public DataNode() {
        this(null);
    }

    public DataNode(String name) {
        this.name = name;
        this.dataMaps = new HashMap();
        this.readThroughDataSource = new TransactionDataSource();
        this.entitySorter = new AshwoodEntitySorter(Collections.EMPTY_LIST);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataSourceLocation() {
        return this.dataSourceLocation;
    }

    public void setDataSourceLocation(String dataSourceLocation) {
        this.dataSourceLocation = dataSourceLocation;
    }

    public String getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(String dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public Collection getDataMaps() {
        return Collections.unmodifiableCollection(this.dataMaps.values());
    }

    public void setDataMaps(Collection dataMaps) {
        Iterator it = dataMaps.iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            this.dataMaps.put(map.getName(), map);
        }
        this.entitySorter.setDataMaps(dataMaps);
    }

    public void addDataMap(DataMap map) {
        this.dataMaps.put(map.getName(), map);
        this.entitySorter.setDataMaps(this.getDataMaps());
    }

    public void removeDataMap(String mapName) {
        DataMap map = (DataMap)this.dataMaps.remove(mapName);
        if (map != null) {
            this.entitySorter.setDataMaps(this.getDataMaps());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource != null ? this.readThroughDataSource : null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public DataNode lookupDataNode(DataMap dataMap) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performQueries(Collection queries, OperationObserver callback) {
        int listSize = queries.size();
        if (listSize == 0) {
            return;
        }
        if (callback.isIteratedResult() && listSize > 1) {
            throw new CayenneRuntimeException("Iterated queries are not allowed in a batch. Batch size: " + listSize);
        }
        QueryLogger.logQueryStart(listSize);
        this.getAdapter().getExtendedTypes();
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (Exception globalEx) {
            QueryLogger.logQueryError(globalEx);
            Transaction transaction = Transaction.getThreadTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
            callback.nextGlobalException(globalEx);
            return;
        }
        try {
            DataNodeQueryAction queryRunner = new DataNodeQueryAction(this, callback);
            Iterator it = queries.iterator();
            while (it.hasNext()) {
                Query nextQuery = (Query)it.next();
                try {
                    queryRunner.runQuery(connection, nextQuery);
                }
                catch (Exception queryEx) {
                    QueryLogger.logQueryError(queryEx);
                    callback.nextQueryException(nextQuery, queryEx);
                    Transaction transaction = Transaction.getThreadTransaction();
                    if (transaction != null) {
                        transaction.setRollbackOnly();
                    }
                    break;
                }
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {}
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    public synchronized void shutdown() {
        try {
            if (this.dataSource instanceof PoolManager) {
                ((PoolManager)this.dataSource).dispose();
                this.dataSource = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    final class TransactionDataSource
    implements DataSource {
        final String CONNECTION_RESOURCE_PREFIX = "DataNode.Connection.";

        TransactionDataSource() {
        }

        public Connection getConnection() throws SQLException {
            Transaction t = Transaction.getThreadTransaction();
            if (t != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            Transaction t = Transaction.getThreadTransaction();
            if (t != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection(username, password);
        }

        public int getLoginTimeout() throws SQLException {
            return DataNode.this.dataSource.getLoginTimeout();
        }

        public PrintWriter getLogWriter() throws SQLException {
            return DataNode.this.dataSource.getLogWriter();
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            DataNode.this.dataSource.setLoginTimeout(seconds);
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            DataNode.this.dataSource.setLogWriter(out);
        }
    }
}

