/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.Util;

class DataRowUtils {
    static void mergeObjectWithSnapshot(DataContext context, ClassDescriptor descriptor, Persistent object, DataRow snapshot) {
        int state = object.getPersistenceState();
        if (state == 5 || descriptor.getEntity().isReadOnly()) {
            DataRowUtils.refreshObjectWithSnapshot(descriptor, object, snapshot, true);
        } else if (state != 3) {
            DataRowUtils.forceMergeWithSnapshot(context, descriptor, object, snapshot);
        } else {
            DataRowUtils.refreshObjectWithSnapshot(descriptor, object, snapshot, false);
        }
    }

    static void refreshObjectWithSnapshot(ClassDescriptor descriptor, final Persistent object, final DataRow snapshot, final boolean invalidateToManyRelationships) {
        final boolean[] isPartialSnapshot = new boolean[1];
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute attr = property.getAttribute();
                String dbAttrPath = attr.getDbAttributePath();
                Object value = snapshot.get(dbAttrPath);
                property.writePropertyDirectly(object, null, value);
                if (value == null && !snapshot.containsKey(dbAttrPath)) {
                    isPartialSnapshot[0] = true;
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                if (invalidateToManyRelationships) {
                    property.invalidate(object);
                }
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                property.invalidate(object);
                return true;
            }
        });
        object.setPersistenceState(isPartialSnapshot[0] ? 5 : 3);
    }

    static void forceMergeWithSnapshot(final DataContext context, ClassDescriptor descriptor, final Persistent object, final DataRow snapshot) {
        final ObjectDiff diff = (ObjectDiff)context.getObjectStore().getChangesByObjectId().get(object.getObjectId());
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                String dbAttrPath = property.getAttribute().getDbAttributePath();
                Object newValue = snapshot.get(dbAttrPath);
                if (newValue != null || snapshot.containsKey(dbAttrPath)) {
                    Object oldValue;
                    Object curValue = property.readPropertyDirectly(object);
                    Object object2 = oldValue = diff != null ? diff.getSnapshotValue(property.getName()) : null;
                    if (Util.nullSafeEquals(curValue, oldValue) && !Util.nullSafeEquals(newValue, curValue)) {
                        property.writePropertyDirectly(object, oldValue, newValue);
                    }
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship relationship = property.getRelationship();
                if (relationship.isToPK() && !DataRowUtils.isToOneTargetModified(property, object, diff)) {
                    DbRelationship dbRelationship = (DbRelationship)relationship.getDbRelationships().get(0);
                    ObjectId id = snapshot.createTargetObjectId(relationship.getTargetEntityName(), dbRelationship);
                    if (diff == null || !diff.containsArcSnapshot(relationship.getName()) || !Util.nullSafeEquals(id, diff.getArcSnapshotValue(relationship.getName()))) {
                        if (id == null) {
                            property.writeProperty(object, null, null);
                        } else {
                            ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
                            if (context.getEntityResolver().lookupInheritanceTree(targetEntity) != null) {
                                property.invalidate(object);
                            } else {
                                property.writeProperty(object, null, context.localObject(id, null));
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    static boolean isToOneTargetModified(ArcProperty property, Persistent object, ObjectDiff diff) {
        ObjectId currentId;
        if (object.getPersistenceState() != 4 || diff == null) {
            return false;
        }
        if (property.isFault(object)) {
            return false;
        }
        Persistent toOneTarget = (Persistent)property.readPropertyDirectly(object);
        ObjectId objectId = currentId = toOneTarget != null ? toOneTarget.getObjectId() : null;
        if (currentId != null && currentId.isTemporary()) {
            return true;
        }
        if (!diff.containsArcSnapshot(property.getName())) {
            return false;
        }
        ObjectId targetId = diff.getArcSnapshotValue(property.getName());
        return !Util.nullSafeEquals(currentId, targetId);
    }

    DataRowUtils() {
    }
}

