/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryLogger {
    private static final Log logObj = LogFactory.getLog((Class)QueryLogger.class);
    public static final int TRIM_VALUES_THRESHOLD = 30;
    static ThreadLocal logLevel = new ThreadLocal();

    public static void sqlLiteralForObject(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("NULL");
        } else if (object instanceof String) {
            buffer.append('\'');
            String literal = (String)object;
            if (literal.length() > 30) {
                literal = literal.substring(0, 30) + "...";
            }
            int curPos = 0;
            int endPos = 0;
            while ((endPos = literal.indexOf(39, curPos)) >= 0) {
                buffer.append(literal.substring(curPos, endPos + 1)).append('\'');
                curPos = endPos + 1;
            }
            if (curPos < literal.length()) {
                buffer.append(literal.substring(curPos));
            }
            buffer.append('\'');
        } else if (object instanceof Byte) {
            IDUtil.appendFormattedByte(buffer, (Byte)object);
        } else if (object instanceof Number) {
            buffer.append(object);
        } else if (object instanceof Date) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof Time) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof java.util.Date) {
            long time = ((java.util.Date)object).getTime();
            buffer.append('\'').append(new Timestamp(time)).append('\'');
        } else if (object instanceof Calendar) {
            long time = ((Calendar)object).getTimeInMillis();
            buffer.append(object.getClass().getName()).append('(').append(new Timestamp(time)).append(')');
        } else if (object instanceof Character) {
            buffer.append(((Character)object).charValue());
        } else if (object instanceof Boolean) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof ParameterBinding) {
            QueryLogger.sqlLiteralForObject(buffer, ((ParameterBinding)object).getValue());
        } else if (object.getClass().isArray()) {
            buffer.append("< ");
            int len = Array.getLength(object);
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                QueryLogger.sqlLiteralForObject(buffer, Array.get(object, i));
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
        } else {
            buffer.append(object.getClass().getName()).append("@").append(System.identityHashCode(object));
        }
    }

    public static void log(String message) {
        if (message != null) {
            logObj.info((Object)message);
        }
    }

    public static void logConnect(String dataSource) {
        if (QueryLogger.isLoggable()) {
            logObj.info((Object)("Connecting. JNDI path: " + dataSource));
        }
    }

    public static void logConnect(String url, String userName, String password) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer("Opening connection: ");
            buf.append(url);
            buf.append("\n\tLogin: ").append(userName);
            buf.append("\n\tPassword: *******");
            logObj.info((Object)buf.toString());
        }
    }

    public static void logPoolCreated(DataSourceInfo dsi) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer("Created connection pool: ");
            if (dsi != null) {
                buf.append(dsi.getDataSourceUrl());
                if (dsi.getAdapterClassName() != null) {
                    buf.append("\n\tCayenne DbAdapter: ").append(dsi.getAdapterClassName());
                }
                buf.append("\n\tDriver class: ").append(dsi.getJdbcDriver());
                if (dsi.getMinConnections() >= 0) {
                    buf.append("\n\tMin. connections in the pool: ").append(dsi.getMinConnections());
                }
                if (dsi.getMaxConnections() >= 0) {
                    buf.append("\n\tMax. connections in the pool: ").append(dsi.getMaxConnections());
                }
            } else {
                buf.append(" pool information unavailable");
            }
            logObj.info((Object)buf.toString());
        }
    }

    public static void logConnectSuccess() {
        logObj.info((Object)"+++ Connecting: SUCCESS.");
    }

    public static void logConnectFailure(Throwable th) {
        logObj.info((Object)"*** Connecting: FAILURE.", th);
    }

    public static void logQuery(String queryStr, List params) {
        QueryLogger.logQuery(queryStr, params, -1L);
    }

    public static void logQuery(String queryStr, List params, long time) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer(queryStr);
            if (params != null && params.size() > 0) {
                buf.append(" [bind: ");
                QueryLogger.sqlLiteralForObject(buf, params.get(0));
                int len = params.size();
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    QueryLogger.sqlLiteralForObject(buf, params.get(i));
                }
                buf.append(']');
            }
            if (time > 5L) {
                buf.append(" - prepared in ").append(time).append(" ms.");
            }
            logObj.info((Object)buf.toString());
        }
    }

    public static void logQueryParameters(String label, List parameters) {
        if (QueryLogger.isLoggable() && parameters.size() > 0) {
            int len = parameters.size();
            StringBuffer buf = new StringBuffer("[");
            buf.append(label).append(": ");
            QueryLogger.sqlLiteralForObject(buf, parameters.get(0));
            for (int i = 1; i < len; ++i) {
                buf.append(", ");
                QueryLogger.sqlLiteralForObject(buf, parameters.get(i));
            }
            buf.append(']');
            logObj.info((Object)buf.toString());
        }
    }

    public static void logSelectCount(int count) {
        QueryLogger.logSelectCount(count, -1L);
    }

    public static void logSelectCount(int count, long time) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer();
            if (count == 1) {
                buf.append("=== returned 1 row.");
            } else {
                buf.append("=== returned ").append(count).append(" rows.");
            }
            if (time >= 0L) {
                buf.append(" - took ").append(time).append(" ms.");
            }
            logObj.info((Object)buf.toString());
        }
    }

    public static void logUpdateCount(int count) {
        if (QueryLogger.isLoggable()) {
            if (count < 0) {
                logObj.info((Object)"=== updated ? rows");
            } else {
                String countStr = count == 1 ? "=== updated 1 row." : "=== updated " + count + " rows.";
                logObj.info((Object)countStr);
            }
        }
    }

    public static void logBeginTransaction(String transactionLabel) {
        logObj.info((Object)("--- " + transactionLabel));
    }

    public static void logCommitTransaction(String transactionLabel) {
        logObj.info((Object)("+++ " + transactionLabel));
    }

    public static void logRollbackTransaction(String transactionLabel) {
        logObj.info((Object)("*** " + transactionLabel));
    }

    public static void logQueryError(Throwable th) {
        if (QueryLogger.isLoggable()) {
            if (th != null) {
                th = Util.unwindException(th);
            }
            logObj.info((Object)"*** error.", th);
            if (th instanceof SQLException) {
                for (SQLException sqlException = ((SQLException)th).getNextException(); sqlException != null; sqlException = sqlException.getNextException()) {
                    logObj.info((Object)"*** nested SQL error.", (Throwable)sqlException);
                }
            }
        }
    }

    public static void logQueryStart(int count) {
        if (QueryLogger.isLoggable()) {
            String countStr = count == 1 ? "--- will run 1 query." : "--- will run " + count + " queries.";
            logObj.info((Object)countStr);
        }
    }

    public static boolean isLoggable() {
        return logObj.isInfoEnabled();
    }
}

