/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLPathTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLPath;
import org.apache.cayenne.ejbql.parser.EJBQLPositionalInputParameter;

class EJBQLConditionTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private List multiColumnOperands;

    EJBQLConditionTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    void addMultiColumnOperand(EJBQLMultiColumnOperand operand) {
        if (this.multiColumnOperands == null) {
            this.multiColumnOperands = new ArrayList(2);
        }
        this.multiColumnOperands.add(operand);
    }

    public boolean visitAnd(EJBQLExpression expression, int finishedChildIndex) {
        this.afterChild(expression, " AND", finishedChildIndex);
        return true;
    }

    public boolean visitBetween(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                if (expression.isNegated()) {
                    this.context.append(" NOT");
                }
                this.context.append(" BETWEEN");
                break;
            }
            case 1: {
                this.context.append(" AND");
            }
        }
        return true;
    }

    public boolean visitOr(EJBQLExpression expression, int finishedChildIndex) {
        this.afterChild(expression, " OR", finishedChildIndex);
        return true;
    }

    public boolean visitEquals(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                this.context.append(" =");
                break;
            }
            case 1: {
                if (this.multiColumnOperands == null) break;
                if (this.multiColumnOperands.size() != 2) {
                    throw new EJBQLException("Invalid multi-column equals expression. Expected 2 multi-column operands, got " + this.multiColumnOperands.size());
                }
                this.context.trim(2);
                EJBQLMultiColumnOperand lhs = (EJBQLMultiColumnOperand)this.multiColumnOperands.get(0);
                EJBQLMultiColumnOperand rhs = (EJBQLMultiColumnOperand)this.multiColumnOperands.get(1);
                Iterator it = lhs.getKeys().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    lhs.appendValue(key);
                    this.context.append(" =");
                    rhs.appendValue(key);
                    if (!it.hasNext()) continue;
                    this.context.append(" AND");
                }
                this.multiColumnOperands = null;
            }
        }
        return true;
    }

    public boolean visitNamedInputParameter(EJBQLExpression expression) {
        String parameter = this.context.bindNamedParameter(expression.getText());
        this.processParameter(parameter);
        return true;
    }

    public boolean visitNot(EJBQLExpression expression) {
        this.context.append(" NOT");
        return true;
    }

    public boolean visitNotEquals(EJBQLExpression expression, int finishedChildIndex) {
        switch (finishedChildIndex) {
            case 0: {
                this.context.append(" <>");
                break;
            }
            case 1: {
                if (this.multiColumnOperands == null) break;
                if (this.multiColumnOperands.size() != 2) {
                    throw new EJBQLException("Invalid multi-column equals expression. Expected 2 multi-column operands, got " + this.multiColumnOperands.size());
                }
                this.context.trim(3);
                EJBQLMultiColumnOperand lhs = (EJBQLMultiColumnOperand)this.multiColumnOperands.get(0);
                EJBQLMultiColumnOperand rhs = (EJBQLMultiColumnOperand)this.multiColumnOperands.get(1);
                Iterator it = lhs.getKeys().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    lhs.appendValue(key);
                    this.context.append(" <>");
                    rhs.appendValue(key);
                    if (!it.hasNext()) continue;
                    this.context.append(" OR");
                }
                this.multiColumnOperands = null;
            }
        }
        return true;
    }

    public boolean visitGreaterThan(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" >");
        }
        return true;
    }

    public boolean visitGreaterOrEqual(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" >=");
        }
        return true;
    }

    public boolean visitLessOrEqual(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" <=");
        }
        return true;
    }

    public boolean visitLessThan(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(" <");
        }
        return true;
    }

    public boolean visitLike(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            if (expression.isNegated()) {
                this.context.append(" NOT");
            }
            this.context.append(" LIKE");
        }
        return true;
    }

    protected void afterChild(EJBQLExpression e, String text, int childIndex) {
        if (childIndex >= 0 && childIndex + 1 < e.getChildrenCount()) {
            this.context.append(text);
        }
    }

    public boolean visitPath(EJBQLPath expression, int finishedChildIndex) {
        expression.visit(new EJBQLPathTranslator(this.context){

            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                EJBQLConditionTranslator.this.addMultiColumnOperand(operand);
            }
        });
        return false;
    }

    public boolean visitIntegerLiteral(EJBQLExpression expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            Integer value;
            try {
                value = new Integer(expression.getText());
            }
            catch (NumberFormatException nfex) {
                throw new EJBQLException("Invalid integer: " + expression.getText());
            }
            String var = this.context.bindParameter(value);
            this.context.append(" #bind($").append(var).append(" 'INTEGER')");
        }
        return true;
    }

    public boolean visitDecimalLiteral(EJBQLExpression expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            BigDecimal value;
            try {
                value = new BigDecimal(expression.getText());
            }
            catch (NumberFormatException nfex) {
                throw new EJBQLException("Invalid decimal: " + expression.getText());
            }
            String var = this.context.bindParameter(value);
            this.context.append(" #bind($").append(var).append(" 'DECIMAL')");
        }
        return true;
    }

    public boolean visitPatternValue(EJBQLExpression expression) {
        return true;
    }

    public boolean visitIsNull(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            this.context.append(expression.isNegated() ? " IS NOT NULL" : " IS NULL");
        }
        return true;
    }

    public boolean visitPositionalInputParameter(EJBQLPositionalInputParameter expression) {
        String parameter = this.context.bindPositionalParameter(expression.getPosition());
        this.processParameter(parameter);
        return true;
    }

    public boolean visitStringLiteral(EJBQLExpression expression) {
        if (expression.getText() == null) {
            this.context.append("null");
        } else {
            this.context.append(" #bind(").append(expression.getText()).append(" 'VARCHAR')");
        }
        return true;
    }

    private void processParameter(String boundName) {
        Object object = this.context.getBoundParameter(boundName);
        Map map = null;
        if (object instanceof Persistent) {
            map = ((Persistent)object).getObjectId().getIdSnapshot();
        } else if (object instanceof ObjectId) {
            map = ((ObjectId)object).getIdSnapshot();
        } else if (object instanceof Map) {
            map = (Map)object;
        }
        if (map != null) {
            if (map.size() == 1) {
                this.context.rebindParameter(boundName, map.values().iterator().next());
            } else {
                this.addMultiColumnOperand(EJBQLMultiColumnOperand.getObjectOperand(this.context, map));
                return;
            }
        }
        if (object != null) {
            this.context.append(" #bind($").append(boundName).append(")");
        } else {
            this.context.append(" #bind($").append(boundName).append(" 'VARCHAR')");
        }
    }
}

