/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.collections.map.LRUMap;

public class MapQueryCache
implements QueryCache,
Serializable {
    public static final int DEFAULT_CACHE_SIZE = 2000;
    protected Map map;

    public MapQueryCache() {
        this(2000);
    }

    public MapQueryCache(int maxSize) {
        this.map = new LRUMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List get(QueryMetadata metadata) {
        CacheEntry entry;
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        MapQueryCache mapQueryCache = this;
        synchronized (mapQueryCache) {
            entry = (CacheEntry)this.map.get(key);
        }
        return entry != null ? entry.list : null;
    }

    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        List result = this.get(metadata);
        if (result == null) {
            Object newObject = factory.createObject();
            if (!(newObject instanceof List)) {
                if (newObject == null) {
                    throw new CayenneRuntimeException("Null on cache rebuilding: " + metadata.getCacheKey());
                }
                throw new CayenneRuntimeException("Invalid query result, expected List, got " + newObject.getClass().getName());
            }
            result = (List)newObject;
            this.put(metadata, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            CacheEntry entry = new CacheEntry();
            entry.list = results;
            entry.cacheGroups = metadata.getCacheGroups();
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                this.map.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (key != null) {
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                this.map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String groupKey) {
        if (groupKey != null) {
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                Iterator it = this.map.values().iterator();
                block3: while (it.hasNext()) {
                    CacheEntry entry = (CacheEntry)it.next();
                    if (entry.cacheGroups == null) continue;
                    for (int i = 0; i < entry.cacheGroups.length; ++i) {
                        if (!groupKey.equals(entry.cacheGroups[i])) continue;
                        it.remove();
                        continue block3;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MapQueryCache mapQueryCache = this;
        synchronized (mapQueryCache) {
            this.map.clear();
        }
    }

    public int size() {
        return this.map.size();
    }

    final class CacheEntry {
        List list;
        String[] cacheGroups;

        CacheEntry() {
        }
    }
}

